/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.ArrayList;
import tim.prune.data.Photo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoList {
    private ArrayList<Photo> _photos = null;

    public PhotoList() {
        this(null);
    }

    private PhotoList(ArrayList<Photo> arrayList) {
        this._photos = arrayList;
    }

    public int getNumPhotos() {
        if (this._photos == null) {
            return 0;
        }
        return this._photos.size();
    }

    public void addPhoto(Photo photo) {
        if (photo != null) {
            if (this._photos == null) {
                this._photos = new ArrayList();
            }
            this._photos.add(photo);
        }
    }

    public void addPhoto(Photo photo, int n) {
        if (photo != null) {
            if (this._photos == null) {
                this._photos = new ArrayList();
            }
            this._photos.add(n, photo);
        }
    }

    public void deletePhoto(int n) {
        if (this._photos != null) {
            this._photos.remove(n);
        }
    }

    public boolean contains(Photo photo) {
        return this.getPhotoIndex(photo) > -1;
    }

    public int getPhotoIndex(Photo photo) {
        int n = this.getNumPhotos();
        if (n <= 0 || photo == null || photo.getFile() == null) {
            return -1;
        }
        Photo photo2 = null;
        int n2 = 0;
        while (n2 < n) {
            photo2 = this.getPhoto(n2);
            if (photo2 != null && photo2.equals(photo)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Photo getPhoto(int n) {
        if (n < 0 || n >= this.getNumPhotos()) {
            return null;
        }
        return this._photos.get(n);
    }

    /*
     * Unable to fully structure code
     */
    public void cropTo(int var1_1) {
        block3: {
            if (var1_1 > 0) ** GOTO lbl7
            if (this._photos == null) break block3;
            this._photos.clear();
            break block3;
lbl-1000:
            // 1 sources

            {
                this._photos.remove(this._photos.size() - 1);
lbl7:
                // 2 sources

                ** while (this._photos.size() > var1_1)
            }
        }
    }

    public String[] getNameList() {
        String[] stringArray = new String[this.getNumPhotos()];
        int n = 0;
        while (n < this.getNumPhotos()) {
            stringArray[n] = this.getPhoto(n).getFile().getName();
            ++n;
        }
        return stringArray;
    }

    public boolean hasCorrelatedPhotos() {
        int n = this.getNumPhotos();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n && !bl) {
            if (this.getPhoto(n2).getDataPoint() != null) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public void removeCorrelatedPhotos() {
        int n = this.getNumPhotos();
        if (n > 0) {
            ArrayList<Photo> arrayList = new ArrayList<Photo>();
            int n2 = 0;
            while (n2 < n) {
                Photo photo = this.getPhoto(n2);
                if (photo != null) {
                    if (photo.getDataPoint() == null) {
                        arrayList.add(photo);
                    } else {
                        photo.resetCachedData();
                    }
                }
                ++n2;
            }
            this._photos = arrayList;
        }
    }

    public PhotoList cloneList() {
        if (this._photos == null) {
            return this;
        }
        ArrayList<Photo> arrayList = new ArrayList<Photo>();
        int n = 0;
        while (n < this._photos.size()) {
            arrayList.add(this._photos.get(n));
            ++n;
        }
        return new PhotoList(arrayList);
    }

    public void restore(PhotoList photoList) {
        if (photoList.getNumPhotos() == 0) {
            this._photos = null;
        } else {
            this._photos.clear();
            this._photos.addAll(photoList._photos);
        }
    }
}

