/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.I18nManager;
import tim.prune.data.FieldType;

public class Field {
    private String _labelKey = null;
    private String _customLabel = null;
    private FieldType _type = null;
    private boolean _builtin = false;
    public static final Field LATITUDE = new Field("fieldname.latitude", FieldType.COORD);
    public static final Field LONGITUDE = new Field("fieldname.longitude", FieldType.COORD);
    public static final Field ALTITUDE = new Field("fieldname.altitude", FieldType.INT);
    public static final Field TIMESTAMP = new Field("fieldname.timestamp", FieldType.TIME);
    public static final Field WAYPT_NAME = new Field("fieldname.waypointname", FieldType.NONE);
    public static final Field WAYPT_TYPE = new Field("fieldname.waypointtype", FieldType.NONE);
    public static final Field NEW_SEGMENT = new Field("fieldname.newsegment", FieldType.BOOL);
    private static final Field[] ALL_AVAILABLE_FIELDS = new Field[]{LATITUDE, LONGITUDE, ALTITUDE, TIMESTAMP, WAYPT_NAME, WAYPT_TYPE, NEW_SEGMENT, new Field("fieldname.custom", FieldType.NONE)};

    private Field(String string, FieldType fieldType) {
        this._labelKey = string;
        this._customLabel = null;
        this._type = fieldType;
        this._builtin = true;
    }

    public Field(String string) {
        this._labelKey = null;
        this._customLabel = string;
        this._type = FieldType.NONE;
    }

    public String getName() {
        if (this._labelKey != null) {
            return I18nManager.getText(this._labelKey);
        }
        return this._customLabel;
    }

    public void setName(String string) {
        if (!this.isBuiltIn()) {
            this._customLabel = string;
        }
    }

    public boolean isBuiltIn() {
        return this._builtin;
    }

    public FieldType getType() {
        return this._type;
    }

    public boolean equals(Field field) {
        return this.isBuiltIn() == field.isBuiltIn() && this.getName().equals(field.getName());
    }

    public static Field getField(String string) {
        int n = 0;
        while (n < ALL_AVAILABLE_FIELDS.length) {
            Field field = ALL_AVAILABLE_FIELDS[n];
            if (field.getName().equals(string)) {
                return field;
            }
            ++n;
        }
        return null;
    }

    public static String[] getFieldNames() {
        String[] stringArray = new String[ALL_AVAILABLE_FIELDS.length];
        int n = 0;
        while (n < ALL_AVAILABLE_FIELDS.length) {
            stringArray[n] = ALL_AVAILABLE_FIELDS[n].getName();
            ++n;
        }
        return stringArray;
    }
}

