/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import tim.prune.correlate.PhotoSelectionTableRow;
import tim.prune.correlate.PointPair;
import tim.prune.data.Distance;

public class PhotoPreviewTableRow
extends PhotoSelectionTableRow {
    private PointPair _pointPair = null;
    private double _distance = 0.0;
    private int _status = 0;
    private boolean _correlate = false;

    public PhotoPreviewTableRow(PointPair pointPair) {
        super(pointPair.getPhoto(), pointPair.getMinSeconds());
        this._pointPair = pointPair;
        this._distance = pointPair.getMinRadians();
        this._status = 0;
        this._correlate = pointPair.getPhoto().getDataPoint() == null;
    }

    public double getDistance(Distance.Units units) {
        return Distance.convertRadiansToDistance(this._distance, units);
    }

    public int getStatus() {
        return this._status;
    }

    public PointPair getPointPair() {
        return this._pointPair;
    }

    public Boolean getCorrelateFlag() {
        return this._correlate;
    }

    public void setCorrelateFlag(boolean bl) {
        this._correlate = bl;
    }
}

