/*
 * Decompiled with CFR 0.152.
 */
package tim.prune;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import tim.prune.ConfigException;

public abstract class Config {
    private static File _workingDir = null;
    private static String _langCode = null;
    private static String _gpsDevice = null;
    private static String _gpsFormat = null;
    private static String _povrayFont = null;
    private static boolean _metricUnits = true;
    private static String _gnuplotPath = null;
    private static int _mapTileServerIndex = -1;
    private static String _mapTileServerUrl = null;
    private static File _configFile = null;
    private static final File DEFAULT_CONFIG_FILE = new File(".pruneconfig");
    private static final String KEY_WORKING_DIR = "prune.directory";
    private static final String KEY_LANGUAGE_CODE = "prune.languagecode";
    private static final String KEY_GPS_DEVICE = "prune.gpsdevice";
    private static final String KEY_GPS_FORMAT = "prune.gpsformat";
    private static final String KEY_POVRAY_FONT = "prune.povrayfont";
    private static final String KEY_METRIC_UNITS = "prune.metricunits";
    private static final String KEY_GNUPLOTPATH = "prune.gnuplotpath";
    private static final String KEY_MAPSERVERINDEX = "prune.mapserverindex";
    private static final String KEY_MAPSERVERURL = "prune.mapserverurl";

    public static File getWorkingDirectory() {
        return _workingDir;
    }

    public static void setWorkingDirectory(File file) {
        _workingDir = file;
    }

    public static void loadDefaultFile() {
        try {
            Config.loadFile(DEFAULT_CONFIG_FILE);
        }
        catch (ConfigException configException) {}
    }

    public static void loadFile(File file) throws ConfigException {
        boolean bl;
        Properties properties;
        block17: {
            properties = Config.getDefaultProperties();
            bl = false;
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                }
                catch (Exception exception) {
                    bl = true;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        _langCode = properties.getProperty(KEY_LANGUAGE_CODE);
        String string = properties.getProperty(KEY_WORKING_DIR);
        if (string != null) {
            Config.setWorkingDirectory(new File(string));
        }
        _gpsDevice = properties.getProperty(KEY_GPS_DEVICE);
        _gpsFormat = properties.getProperty(KEY_GPS_FORMAT);
        _povrayFont = properties.getProperty(KEY_POVRAY_FONT);
        String string2 = properties.getProperty(KEY_METRIC_UNITS);
        _metricUnits = string2 == null || string2.equals("") || string2.toLowerCase().equals("y");
        _gnuplotPath = properties.getProperty(KEY_GNUPLOTPATH);
        if (_gnuplotPath == null || _gnuplotPath.equals("")) {
            _gnuplotPath = "gnuplot";
        }
        _mapTileServerIndex = Config.parseInt(properties.getProperty(KEY_MAPSERVERINDEX));
        _mapTileServerUrl = properties.getProperty(KEY_MAPSERVERURL);
        if (bl) {
            throw new ConfigException();
        }
        _configFile = file;
    }

    private static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put(KEY_GPS_DEVICE, "usb:");
        properties.put(KEY_GPS_FORMAT, "garmin");
        properties.put(KEY_POVRAY_FONT, "crystal.ttf");
        return properties;
    }

    private static int parseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        return n;
    }

    public static String getLanguageCode() {
        return _langCode;
    }

    public static String getGpsDevice() {
        return _gpsDevice;
    }

    public static String getGpsFormat() {
        return _gpsFormat;
    }

    public static String getPovrayFont() {
        return _povrayFont;
    }

    public static boolean getUseMetricUnits() {
        return _metricUnits;
    }

    public static void setUseMetricUnits(boolean bl) {
        _metricUnits = bl;
    }

    public static String getGnuplotPath() {
        return _gnuplotPath;
    }

    public static void setGnuplotPath(String string) {
        _gnuplotPath = string;
    }

    public static int getMapServerIndex() {
        return _mapTileServerIndex;
    }

    public static void setMapServerIndex(int n) {
        _mapTileServerIndex = n;
    }

    public static String getMapServerUrl() {
        return _mapTileServerUrl;
    }

    public static void setMapServerUrl(String string) {
        _mapTileServerUrl = string;
    }

    public static File getConfigFile() {
        return _configFile;
    }
}

