/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.postgis;

import com.vividsolutions.jump.workbench.ui.AbstractDriverPanel;
import com.vividsolutions.jump.workbench.ui.DriverPanelCache;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.refractions.postgis.PostGISCommonDriverPanel;

public class PostGISSaveDriverPanel
extends AbstractDriverPanel
implements ActionListener {
    static final String INSERT_HELP_STRING = "Create the table if it doesn't already exist, then insert new geometries into it.";
    static final String UPDATE_HELP_STRING = "Update the existing geometries in the table, based on the specified unique column. You must specify a unique column name which exists in both the feature schema and the database table.";
    ButtonGroup methodButtons;
    JRadioButton insertButton;
    JRadioButton updateButton;
    JTextArea help;
    JTextField uniqueField;
    PostGISCommonDriverPanel commonPanel;
    OKCancelPanel okCancelPanel;

    public PostGISSaveDriverPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        Insets insets;
        this.setLayout(new BorderLayout());
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(gbLayout);
        c.insets = insets = new Insets(2, 2, 2, 2);
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select Save Method:");
        border.setTitleJustification(1);
        topPanel.setBorder(border);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.insertButton = new JRadioButton("Insert");
        this.insertButton.setActionCommand("insert");
        this.insertButton.addActionListener(this);
        gbLayout.setConstraints(this.insertButton, c);
        topPanel.add(this.insertButton);
        c.gridy = 1;
        c.anchor = 17;
        this.updateButton = new JRadioButton("Update");
        this.updateButton.setActionCommand("update");
        this.updateButton.addActionListener(this);
        gbLayout.setConstraints(this.updateButton, c);
        topPanel.add(this.updateButton);
        this.methodButtons = new ButtonGroup();
        this.methodButtons.add(this.insertButton);
        this.methodButtons.add(this.updateButton);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 13;
        JLabel theLabel = new JLabel("Unique Column:");
        gbLayout.setConstraints(theLabel, c);
        topPanel.add(theLabel);
        c.gridx = 1;
        c.anchor = 17;
        this.uniqueField = new JTextField(15);
        gbLayout.setConstraints(this.uniqueField, c);
        topPanel.add(this.uniqueField);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        this.help = new JTextArea(4, 40);
        this.help.setEditable(false);
        this.help.setLineWrap(true);
        this.help.setWrapStyleWord(true);
        this.help.setBackground(topPanel.getBackground());
        this.help.setFont(new Font("Sans-Serif", 0, 12));
        gbLayout.setConstraints(this.help, c);
        topPanel.add(this.help);
        this.add(topPanel, "North");
        this.commonPanel = new PostGISCommonDriverPanel();
        this.add(this.commonPanel, "Center");
        this.okCancelPanel = new OKCancelPanel();
        this.setSaveMethod("INSERT");
    }

    public String getValidationError() {
        return null;
    }

    public void addActionListener(ActionListener l) {
        this.okCancelPanel.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.okCancelPanel.removeActionListener(l);
    }

    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    public void setCache(DriverPanelCache cache) {
        super.setCache(cache);
        this.commonPanel.setCache(cache);
        if (cache.get("SAVE_METHOD") != null) {
            this.setSaveMethod((String)cache.get("SAVE_METHOD"));
        }
        if (cache.get("UNIQUE_COLUMN") != null) {
            this.uniqueField.setText((String)cache.get("UNIQUE_COLUMN"));
        }
    }

    public DriverPanelCache getCache() {
        DriverPanelCache cache = super.getCache();
        this.commonPanel.putCache(cache);
        cache.put("SAVE_METHOD", (Object)this.getSaveMethod());
        cache.put("UNIQUE_COLUMN", (Object)this.uniqueField.getText());
        return cache;
    }

    private void setSaveMethod(String method) {
        if (method.equals("UPDATE")) {
            this.updateButton.doClick();
        } else {
            this.insertButton.doClick();
        }
    }

    public String getSaveMethod() {
        if (this.methodButtons.isSelected(this.updateButton.getModel())) {
            return "UPDATE";
        }
        return "INSERT";
    }

    public String getUniqueColumn() {
        return this.uniqueField.getText();
    }

    public String getServer() {
        return this.commonPanel.getServer();
    }

    public String getPort() {
        return this.commonPanel.getPort();
    }

    public String getDatabase() {
        return this.commonPanel.getDatabase();
    }

    public String getTable() {
        return this.commonPanel.getTable();
    }

    public String getUsername() {
        return this.commonPanel.getUsername();
    }

    public String getPassword() {
        return this.commonPanel.getPassword();
    }

    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        if (action.equals("insert")) {
            this.uniqueField.setEnabled(false);
            this.help.setText(INSERT_HELP_STRING);
        } else if (action.equals("update")) {
            this.uniqueField.setEnabled(true);
            this.help.setText(UPDATE_HELP_STRING);
        }
    }
}

