/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.postgis;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.refractions.postgis.PostGISDataSource;
import net.refractions.postgis.PostGISDataSourceQuery;
import net.refractions.postgis.PostGISDataSourceQueryChooser;
import net.refractions.postgis.PostGISSaveDriverPanel;

public class PostGISSaveDataSourceQueryChooser
extends PostGISDataSourceQueryChooser {
    private PostGISSaveDriverPanel panel = new PostGISSaveDriverPanel();
    private HashMap properties;
    ButtonGroup methodButtons;
    JRadioButton insertButton;
    JRadioButton updateButton;
    JTextArea help;
    JTextField uniqueField;

    public PostGISSaveDataSourceQueryChooser(PostGISDataSource dataSource) {
        super(dataSource);
    }

    public Component getComponent() {
        return this.panel;
    }

    public Collection getDataSourceQueries() {
        StringBuffer sql = new StringBuffer();
        HashMap properties = super.getProperties();
        PostGISDataSourceQuery query = new PostGISDataSourceQuery(this.getDataSource(), null, (String)properties.get("TABLE"));
        query.setProperties(this.getProperties());
        ArrayList<PostGISDataSourceQuery> queries = new ArrayList<PostGISDataSourceQuery>();
        queries.add(query);
        return queries;
    }

    public boolean isInputValid() {
        if (!super.isInputValid()) {
            return false;
        }
        return !this.panel.getSaveMethod().equals("UPDATE") || !this.panel.getUniqueColumn().equals("");
    }

    protected HashMap getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put("SERVER", this.panel.getServer());
        this.properties.put("PORT", this.panel.getPort());
        this.properties.put("DATABASE", this.panel.getDatabase());
        this.properties.put("TABLE", this.panel.getTable());
        this.properties.put("USERNAME", this.panel.getUsername());
        this.properties.put("PASSWORD", this.panel.getPassword());
        this.properties.put("SAVE_METHOD", this.panel.getSaveMethod());
        this.properties.put("UNIQUE_COLUMN", this.panel.getUniqueColumn());
        return this.properties;
    }
}

