/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.postgis;

import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.postgis.PostGISPlugIn;

public class PostGISConnection
implements com.vividsolutions.jump.io.datasource.Connection {
    Map properties;
    String server;
    String port;
    String database;
    String table;
    String username;
    String password;
    String uniqueCol;
    String method;

    public PostGISConnection() {
        this(null);
    }

    public PostGISConnection(Map properties) {
        this.properties = properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public FeatureCollection executeQuery(String query) {
        FeatureDataset dataSet;
        this.readProperties();
        Connection conn = this.connect();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query + " LIMIT 0");
            ResultSetMetaData meta = rs.getMetaData();
            boolean geomCol = false;
            FeatureSchema schema = new FeatureSchema();
            StringBuffer sql = new StringBuffer("SELECT");
            int num_cols = meta.getColumnCount();
            for (int col_idx = 1; col_idx <= num_cols; ++col_idx) {
                String attr_name = meta.getColumnName(col_idx);
                String table_name = meta.getTableName(col_idx);
                AttributeType attr_type = AttributeType.STRING;
                if (meta.getColumnTypeName(col_idx).equalsIgnoreCase("geometry") && !geomCol) {
                    geomCol = true;
                    attr_type = AttributeType.GEOMETRY;
                    sql.append(" asText(" + attr_name + ") AS " + attr_name + ",");
                } else {
                    int sql_type = meta.getColumnType(col_idx);
                    switch (sql_type) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            attr_type = AttributeType.INTEGER;
                            sql.append(" " + attr_name + ",");
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            attr_type = AttributeType.DOUBLE;
                            sql.append(" " + attr_name + ",");
                            break;
                        }
                        default: {
                            attr_type = AttributeType.STRING;
                            sql.append(" " + attr_name + ",");
                        }
                    }
                }
                schema.addAttribute(attr_name, attr_type);
            }
            rs.close();
            if (!geomCol) {
                st.close();
                conn.close();
                throw new IllegalStateException("The table you have selected does not contain any geometric data.");
            }
            sql.deleteCharAt(sql.lastIndexOf(","));
            sql.append(" FROM " + this.table);
            st.execute("BEGIN");
            String s = "DECLARE my_cursor CURSOR FOR " + sql.toString();
            st.execute("DECLARE my_cursor CURSOR FOR " + sql.toString());
            rs = st.executeQuery("FETCH FORWARD ALL IN my_cursor");
            dataSet = new FeatureDataset(schema);
            GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 0);
            WKTReader wktReader = new WKTReader(factory);
            while (rs.next()) {
                BasicFeature f = new BasicFeature(schema);
                for (int attr_idx = 0; attr_idx < schema.getAttributeCount(); ++attr_idx) {
                    AttributeType attr_type = schema.getAttributeType(attr_idx);
                    if (attr_type.equals(AttributeType.GEOMETRY)) {
                        Reader wkt = rs.getCharacterStream(schema.getAttributeName(attr_idx));
                        Object geom = wkt == null ? new GeometryCollection(null, factory) : wktReader.read(wkt);
                        f.setAttribute(attr_idx, geom);
                        continue;
                    }
                    if (attr_type.equals(AttributeType.INTEGER)) {
                        f.setAttribute(attr_idx, (Object)new Integer(rs.getInt(schema.getAttributeName(attr_idx))));
                        continue;
                    }
                    if (attr_type.equals(AttributeType.DOUBLE)) {
                        f.setAttribute(attr_idx, (Object)new Double(rs.getDouble(schema.getAttributeName(attr_idx))));
                        continue;
                    }
                    if (!attr_type.equals(AttributeType.STRING)) continue;
                    f.setAttribute(attr_idx, (Object)rs.getString(schema.getAttributeName(attr_idx)));
                }
                dataSet.add((Feature)f);
            }
            st.execute("CLOSE my_cursor");
            st.execute("END");
            st.close();
            conn.close();
        }
        catch (Exception e) {
            if (PostGISPlugIn.DEBUG) {
                e.printStackTrace();
            }
            throw new IllegalStateException(e.getMessage());
        }
        return dataSet;
    }

    public FeatureCollection executeQuery(String query, List exceptions) {
        return this.executeQuery(query);
    }

    public void executeUpdate(String query, FeatureCollection collection) {
        boolean table_exists;
        String sql;
        StringBuffer sqlBuf;
        HashSet<String> cols;
        Statement stmt;
        Connection conn;
        FeatureSchema schema;
        int SRID;
        block38: {
            if (collection.isEmpty()) {
                throw new IllegalStateException("No data to write, empty Feature Collection");
            }
            SRID = ((Feature)collection.iterator().next()).getGeometry().getSRID();
            schema = collection.getFeatureSchema();
            HashSet<String> schemaCols = new HashSet<String>(schema.getAttributeCount());
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                String name = schema.getAttributeName(i);
                if (schemaCols.contains(name)) {
                    throw new UnsupportedOperationException("The FeatureSchema contains duplicate attribute names; you must remove duplicate attribute names before saving to a PostGIS table.");
                }
                schemaCols.add(name);
            }
            conn = null;
            stmt = null;
            cols = null;
            sqlBuf = null;
            sql = null;
            this.readProperties();
            conn = this.connect();
            table_exists = false;
            try {
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.table + " LIMIT 0");
                ResultSetMetaData meta = rs.getMetaData();
                int num_cols = meta.getColumnCount();
                cols = new HashSet<String>(num_cols);
                for (int col_idx = 1; col_idx <= num_cols; ++col_idx) {
                    cols.add(meta.getColumnName(col_idx));
                }
                rs.close();
                table_exists = true;
            }
            catch (SQLException sqle) {
                table_exists = false;
                if (this.method != "UPDATE") break block38;
                throw new IllegalStateException("Save method is set to UPDATE and table does not exist; cannot update a non-existant table");
            }
        }
        try {
            conn.setAutoCommit(false);
            String geomCol = null;
            if (!table_exists) {
                sqlBuf = new StringBuffer("CREATE TABLE " + this.table + " (");
                int num_attrs = schema.getAttributeCount();
                cols = new HashSet(num_attrs);
                for (int i = 0; i < num_attrs; ++i) {
                    String name = schema.getAttributeName(i);
                    cols.add(name);
                    AttributeType type = schema.getAttributeType(i);
                    if (type.equals(AttributeType.INTEGER)) {
                        sqlBuf.append(" " + name + " INT,");
                        continue;
                    }
                    if (type.equals(AttributeType.DOUBLE)) {
                        sqlBuf.append("  DOUBLE,");
                        continue;
                    }
                    if (type.equals(AttributeType.GEOMETRY)) {
                        if (geomCol != null) continue;
                        geomCol = name;
                        continue;
                    }
                    sqlBuf.append(" " + name + " VARCHAR(255),");
                }
                sqlBuf.deleteCharAt(sqlBuf.lastIndexOf(","));
                sqlBuf.append(" ) ");
                sql = sqlBuf.toString();
                try {
                    stmt.executeUpdate(sql);
                }
                catch (SQLException sqle) {
                    if (PostGISPlugIn.DEBUG) {
                        System.out.println(sql);
                        sqle.printStackTrace();
                    }
                    throw new Exception("Create table statement failed: " + sqle.toString() + "\n" + sql);
                }
                sql = "SELECT AddGeometryColumn( '" + this.database + "', '" + this.table + "', '" + geomCol + "', " + SRID + ", 'GEOMETRY', 2 )";
                try {
                    stmt.execute(sql);
                }
                catch (SQLException sqle) {
                    if (PostGISPlugIn.DEBUG) {
                        System.out.println(sql);
                        sqle.printStackTrace();
                    }
                    throw new Exception("AddGeometryColumn statement failed: " + sqle.toString() + "\n" + sql);
                }
            }
            if (this.method == "UPDATE") {
                if (!cols.contains(this.uniqueCol)) {
                    throw new Exception("The table " + this.table + " doesn't contain the column " + this.uniqueCol + ", required in order to do updates.");
                }
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    String uniqueVal = null;
                    Feature f = (Feature)it.next();
                    sqlBuf = new StringBuffer("UPDATE " + this.table + " SET ");
                    for (int i = 0; i < schema.getAttributeCount(); ++i) {
                        String name = schema.getAttributeName(i);
                        if (!cols.contains(name)) continue;
                        AttributeType type = schema.getAttributeType(i);
                        String val = type.equals(AttributeType.INTEGER) ? "" + f.getInteger(i) : (type.equals(AttributeType.DOUBLE) ? "" + f.getDouble(i) : (type.equals(AttributeType.GEOMETRY) ? "GeometryFromText( '" + f.getGeometry().toText() + "', " + f.getGeometry().getSRID() + ")" : "'" + f.getString(i) + "'"));
                        if (name.equals(this.uniqueCol)) {
                            uniqueVal = val;
                            continue;
                        }
                        sqlBuf.append(" " + name + " = " + val + ",");
                    }
                    sqlBuf.deleteCharAt(sqlBuf.lastIndexOf(","));
                    sqlBuf.append(" WHERE " + this.uniqueCol + " = " + uniqueVal);
                    sql = sqlBuf.toString();
                    try {
                        stmt.executeUpdate(sql);
                    }
                    catch (SQLException sqle) {
                        throw new Exception("Update statement failed: " + sqle.toString() + "\n" + sql);
                    }
                }
            } else {
                sqlBuf = new StringBuffer("INSERT INTO " + this.table + " (");
                for (int i = 0; i < schema.getAttributeCount(); ++i) {
                    String name = schema.getAttributeName(i);
                    if (!cols.contains(name)) continue;
                    sqlBuf.append(" " + name + ",");
                }
                sqlBuf.deleteCharAt(sqlBuf.lastIndexOf(","));
                sqlBuf.append(" ) VALUES (");
                String insertQueryHead = sqlBuf.toString();
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    Feature f = (Feature)it.next();
                    sqlBuf = new StringBuffer(insertQueryHead);
                    for (int i = 0; i < schema.getAttributeCount(); ++i) {
                        String name = schema.getAttributeName(i);
                        if (!cols.contains(name)) continue;
                        AttributeType type = schema.getAttributeType(i);
                        if (type.equals(AttributeType.INTEGER)) {
                            sqlBuf.append(" " + f.getInteger(i) + ",");
                            continue;
                        }
                        if (type.equals(AttributeType.DOUBLE)) {
                            sqlBuf.append(" " + f.getDouble(i) + ",");
                            continue;
                        }
                        if (type.equals(AttributeType.GEOMETRY)) {
                            sqlBuf.append(" GeometryFromText( '" + f.getGeometry().toText() + "', " + f.getGeometry().getSRID() + "),");
                            continue;
                        }
                        sqlBuf.append(" '" + f.getString(i) + "',");
                    }
                    sqlBuf.deleteCharAt(sqlBuf.lastIndexOf(","));
                    sqlBuf.append(" ) ");
                    sql = sqlBuf.toString();
                    try {
                        stmt.executeUpdate(sql);
                    }
                    catch (SQLException sqle) {
                        throw new Exception("Insert statement failed: " + sqle.toString() + "\n" + sql);
                    }
                }
            }
            conn.commit();
            stmt.close();
            conn.close();
        }
        catch (Exception e) {
            block39: {
                try {
                    conn.rollback();
                    stmt.close();
                    conn.close();
                }
                catch (SQLException sqle) {
                    if (!PostGISPlugIn.DEBUG) break block39;
                    sqle.printStackTrace();
                }
            }
            if (PostGISPlugIn.DEBUG) {
                e.printStackTrace();
            }
            throw new IllegalStateException(e.getMessage());
        }
    }

    private void readProperties() {
        this.server = (String)this.properties.get("SERVER");
        this.port = (String)this.properties.get("PORT");
        this.database = (String)this.properties.get("DATABASE");
        this.table = (String)this.properties.get("TABLE");
        this.username = (String)this.properties.get("USERNAME");
        this.password = (String)this.properties.get("PASSWORD");
        this.uniqueCol = (String)this.properties.get("UNIQUE_COLUMN");
        this.method = (String)this.properties.get("SAVE_METHOD");
    }

    private Connection connect() {
        try {
            String jdbcUrl = "jdbc:postgresql://" + this.server + ":" + this.port + "/" + this.database;
            Class.forName("org.postgresql.Driver");
            return DriverManager.getConnection(jdbcUrl, this.username, this.password);
        }
        catch (ClassNotFoundException cnfe) {
            if (PostGISPlugIn.DEBUG) {
                cnfe.printStackTrace();
            }
            throw new IllegalStateException("Could not load PostgresSQL driver: " + cnfe.getMessage());
        }
        catch (SQLException sqle) {
            if (PostGISPlugIn.DEBUG) {
                sqle.printStackTrace();
            }
            throw new IllegalStateException("Could not connection to database: " + sqle.getMessage());
        }
    }

    public void close() {
    }

    public FeatureCollection executeQuery(String query, Collection exceptions, TaskMonitor monitor) {
        return this.executeQuery(query);
    }

    public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
        return this.executeQuery(query);
    }

    public void executeUpdate(String query, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
        this.executeUpdate(query, featureCollection);
    }
}

