/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.TargetJDK1_3;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.TargetJDK1_5;
import net.sourceforge.pmd.TargetJDKVersion;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.pmd.jaxen.MatchesFunction;
import net.sourceforge.pmd.jsp.ast.JspCharStream;
import net.sourceforge.pmd.jsp.ast.JspParser;
import net.sourceforge.pmd.util.designer.CodeEditorTextPane;
import net.sourceforge.pmd.util.designer.DFAGraphRule;
import net.sourceforge.pmd.util.designer.DFAPanel;
import net.sourceforge.pmd.util.designer.MyPrintStream;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;

public class Designer
implements ClipboardOwner {
    private final CodeEditorTextPane codeEditorPane = new CodeEditorTextPane();
    private final JTextArea astArea = new JTextArea();
    private DefaultListModel xpathResults = new DefaultListModel();
    private final JList xpathResultList = new JList(this.xpathResults);
    private final JTextArea xpathQueryArea = new JTextArea(15, 30);
    private final JFrame frame = new JFrame("PMD Rule Designer");
    private final DFAPanel dfaPanel = new DFAPanel();
    private JRadioButtonMenuItem jdk13MenuItem;
    private JRadioButtonMenuItem jdk14MenuItem;
    private JRadioButtonMenuItem jdk15MenuItem;
    private JRadioButtonMenuItem jspMenuItem;
    static /* synthetic */ Class class$javax$swing$JTabbedPane;

    private JavaParser createParser() {
        return this.getJDKVersion().createParser(new StringReader(this.codeEditorPane.getText()));
    }

    private JspParser createJspParser() {
        return new JspParser(new JspCharStream(new StringReader(this.codeEditorPane.getText())));
    }

    private SimpleNode getCompilationUnit() {
        if (this.getSourceType().equals(SourceType.JSP)) {
            return this.createJspParser().CompilationUnit();
        }
        return this.createParser().CompilationUnit();
    }

    private TargetJDKVersion getJDKVersion() {
        if (this.jdk14MenuItem.isSelected()) {
            return new TargetJDK1_4();
        }
        if (this.jdk13MenuItem.isSelected()) {
            return new TargetJDK1_3();
        }
        return new TargetJDK1_5();
    }

    private SourceType getSourceType() {
        if (this.jspMenuItem.isSelected()) {
            return SourceType.JSP;
        }
        if (this.jdk14MenuItem.isSelected()) {
            return SourceType.JAVA_14;
        }
        if (this.jdk13MenuItem.isSelected()) {
            return SourceType.JAVA_13;
        }
        return SourceType.JAVA_15;
    }

    public Designer() {
        MatchesFunction.registerSelfInSimpleContext();
        this.xpathQueryArea.setFont(new Font("Verdana", 0, 16));
        JSplitPane controlSplitPane = new JSplitPane(1, new JScrollPane(this.codeEditorPane), this.createXPathQueryPanel());
        JSplitPane resultsSplitPane = new JSplitPane(1, this.createASTPanel(), this.createXPathResultPanel());
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.addTab("Abstract Syntax Tree / XPath", resultsSplitPane);
        tabbed.addTab("Data Flow Analysis", this.dfaPanel);
        try {
            Method setMnemonicAt = (class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = Designer.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane).getMethod("setMnemonicAt", Integer.TYPE, Integer.TYPE);
            if (setMnemonicAt != null) {
                setMnemonicAt.invoke((Object)tabbed, new Integer(0), new Integer(65));
                setMnemonicAt.invoke((Object)tabbed, new Integer(1), new Integer(68));
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        JSplitPane containerSplitPane = new JSplitPane(0, controlSplitPane, tabbed);
        containerSplitPane.setContinuousLayout(true);
        JMenuBar menuBar = this.createMenuBar();
        this.frame.setJMenuBar(menuBar);
        this.frame.getContentPane().add(containerSplitPane);
        this.frame.setDefaultCloseOperation(3);
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.frame.setSize(screenHeight - screenHeight / 4, screenHeight - screenHeight / 4);
        this.frame.setLocation(screenWidth / 2 - this.frame.getWidth() / 2, screenHeight / 2 - this.frame.getHeight() / 2);
        this.frame.setVisible(true);
        this.frame.pack();
        this.frame.show();
        resultsSplitPane.setDividerLocation(resultsSplitPane.getMaximumDividerLocation() - resultsSplitPane.getMaximumDividerLocation() / 2);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("JDK");
        ButtonGroup group = new ButtonGroup();
        this.jdk13MenuItem = new JRadioButtonMenuItem("JDK 1.3");
        this.jdk13MenuItem.setSelected(false);
        group.add(this.jdk13MenuItem);
        menu.add(this.jdk13MenuItem);
        this.jdk14MenuItem = new JRadioButtonMenuItem("JDK 1.4");
        this.jdk14MenuItem.setSelected(true);
        group.add(this.jdk14MenuItem);
        menu.add(this.jdk14MenuItem);
        this.jdk15MenuItem = new JRadioButtonMenuItem("JDK 1.5");
        this.jdk15MenuItem.setSelected(false);
        group.add(this.jdk15MenuItem);
        menu.add(this.jdk15MenuItem);
        this.jspMenuItem = new JRadioButtonMenuItem("JSP");
        this.jspMenuItem.setSelected(false);
        group.add(this.jspMenuItem);
        menu.add(this.jspMenuItem);
        menuBar.add(menu);
        JMenu actionsMenu = new JMenu("Actions");
        JMenuItem copyXMLItem = new JMenuItem("Copy xml to clipboard");
        copyXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.copyXmlToClipboard();
            }
        });
        actionsMenu.add(copyXMLItem);
        JMenuItem createRuleXMLItem = new JMenuItem("Create rule XML");
        createRuleXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.createRuleXML();
            }
        });
        actionsMenu.add(createRuleXMLItem);
        menuBar.add(actionsMenu);
        return menuBar;
    }

    private void createRuleXML() {
        JPanel rulenamePanel = new JPanel();
        rulenamePanel.setLayout(new FlowLayout());
        rulenamePanel.add(new JLabel("Rule name"));
        final JTextField rulenameField = new JTextField(30);
        rulenamePanel.add(rulenameField);
        JPanel rulemsgPanel = new JPanel();
        rulemsgPanel.setLayout(new FlowLayout());
        rulemsgPanel.add(new JLabel("Rule msg"));
        final JTextField rulemsgField = new JTextField(60);
        rulemsgPanel.add(rulemsgField);
        JPanel ruledescPanel = new JPanel();
        ruledescPanel.setLayout(new FlowLayout());
        ruledescPanel.add(new JLabel("Rule desc"));
        final JTextField ruledescField = new JTextField(60);
        ruledescPanel.add(ruledescField);
        JPanel ruleXMLPanel = new JPanel();
        final JTextArea ruleXMLArea = new JTextArea(30, 50);
        ruleXMLPanel.add(ruleXMLArea);
        JButton go = new JButton("Create rule XML");
        go.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StringBuffer sb = new StringBuffer();
                sb.append("<rule  name=\"" + rulenameField.getText() + "\"" + PMD.EOL);
                sb.append("  message=\"" + rulemsgField.getText() + "\"" + PMD.EOL);
                sb.append("  class=\"" + (Designer.this.xpathQueryArea.getText().length() == 0 ? "" : "net.sourceforge.pmd.rules.XPathRule") + "\">" + PMD.EOL);
                sb.append("  <description>" + PMD.EOL);
                sb.append("  " + ruledescField.getText() + PMD.EOL);
                sb.append("  </description>" + PMD.EOL);
                if (Designer.this.xpathQueryArea.getText().length() != 0) {
                    sb.append("  <properties>" + PMD.EOL);
                    sb.append("    <property name=\"xpath\">" + PMD.EOL);
                    sb.append("    <value>" + PMD.EOL);
                    sb.append("<![CDATA[" + PMD.EOL);
                    sb.append(Designer.this.xpathQueryArea.getText() + PMD.EOL);
                    sb.append("]]>" + PMD.EOL);
                    sb.append("    </value>" + PMD.EOL);
                    sb.append("    </property>" + PMD.EOL);
                    sb.append("  </properties>" + PMD.EOL);
                }
                sb.append("  <priority>3</priority>" + PMD.EOL);
                sb.append("  <example>" + PMD.EOL);
                sb.append("<![CDATA[" + PMD.EOL);
                sb.append(Designer.this.codeEditorPane.getText());
                sb.append("]]>" + PMD.EOL);
                sb.append("  </example>" + PMD.EOL);
                sb.append("</rule>" + PMD.EOL);
                ruleXMLArea.setText(sb.toString());
            }
        });
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new BorderLayout());
        fieldsPanel.add((Component)rulenamePanel, "North");
        fieldsPanel.add((Component)rulemsgPanel, "Center");
        fieldsPanel.add((Component)ruledescPanel, "South");
        JPanel fieldBtnPanel = new JPanel();
        fieldBtnPanel.setLayout(new BorderLayout());
        fieldBtnPanel.add((Component)fieldsPanel, "North");
        fieldBtnPanel.add((Component)go, "South");
        JPanel outer = new JPanel(new BorderLayout());
        outer.add((Component)fieldBtnPanel, "North");
        outer.add((Component)ruleXMLPanel, "South");
        JDialog d = new JDialog(this.frame);
        d.setSize(200, 300);
        d.getContentPane().add(outer);
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        d.setLocation(screenWidth / 2 - this.frame.getWidth() / 2, screenHeight / 2 - this.frame.getHeight() / 2);
        d.setVisible(true);
        d.pack();
        d.show();
    }

    private JComponent createASTPanel() {
        this.astArea.setRows(10);
        this.astArea.setColumns(20);
        JScrollPane astScrollPane = new JScrollPane(this.astArea);
        return astScrollPane;
    }

    private JComponent createXPathResultPanel() {
        this.xpathResults.addElement("No results yet");
        this.xpathResultList.setBorder(BorderFactory.createLineBorder(Color.black));
        this.xpathResultList.setFixedCellWidth(300);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.xpathResultList);
        return scrollPane;
    }

    private JPanel createXPathQueryPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.xpathQueryArea.setBorder(BorderFactory.createLineBorder(Color.black));
        JScrollPane scrollPane = new JScrollPane(this.xpathQueryArea);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        JButton b = this.createGoButton();
        p.add((Component)new JLabel("XPath Query (if any)"), "North");
        p.add((Component)scrollPane, "Center");
        p.add((Component)b, "South");
        return p;
    }

    private JButton createGoButton() {
        JButton b = new JButton("Go");
        b.setMnemonic('g');
        b.addActionListener(new ShowListener());
        b.addActionListener(this.codeEditorPane);
        b.addActionListener(new XPathListener());
        b.addActionListener(new DFAListener());
        return b;
    }

    public static void main(String[] args) {
        new Designer();
    }

    private final void copyXmlToClipboard() {
        if (this.codeEditorPane.getText() != null && this.codeEditorPane.getText().trim().length() > 0) {
            String xml = "";
            SimpleNode cu = this.getCompilationUnit();
            if (cu != null) {
                try {
                    xml = this.getXmlString(cu);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    xml = "Error trying to construct XML representation";
                }
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(xml), this);
        }
    }

    private String getXmlString(SimpleNode node) throws IOException {
        StringWriter writer = new StringWriter();
        XMLSerializer xmlSerializer = new XMLSerializer((Writer)writer, new OutputFormat("XML", "UTF-8", true));
        xmlSerializer.asDOMSerializer();
        xmlSerializer.serialize(node.asXml());
        return writer.toString();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class XPathListener
    implements ActionListener {
        private XPathListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            Designer.this.xpathResults.clear();
            if (Designer.this.xpathQueryArea.getText().length() == 0) {
                Designer.this.xpathResults.addElement("XPath query field is empty");
                Designer.this.xpathResultList.repaint();
                Designer.this.codeEditorPane.requestFocus();
                return;
            }
            SimpleNode c = Designer.this.getCompilationUnit();
            try {
                BaseXPath xpath = new BaseXPath(Designer.this.xpathQueryArea.getText(), new DocumentNavigator());
                Iterator iter = xpath.selectNodes(c).iterator();
                while (iter.hasNext()) {
                    StringBuffer sb = new StringBuffer();
                    Object obj = iter.next();
                    if (obj instanceof String) {
                        System.out.println("Result was a string: " + (String)obj);
                        continue;
                    }
                    if (obj instanceof Boolean) continue;
                    SimpleNode node = (SimpleNode)obj;
                    String name = node.getClass().getName().substring(node.getClass().getName().lastIndexOf(46) + 1);
                    String line = " at line " + String.valueOf(node.getBeginLine());
                    sb.append(name).append(line).append(System.getProperty("line.separator"));
                    Designer.this.xpathResults.addElement(sb.toString().trim());
                }
                if (Designer.this.xpathResults.isEmpty()) {
                    Designer.this.xpathResults.addElement("No matching nodes " + System.currentTimeMillis());
                }
            }
            catch (ParseException pe) {
                Designer.this.xpathResults.addElement(pe.fillInStackTrace().getMessage());
            }
            catch (JaxenException je) {
                Designer.this.xpathResults.addElement(je.fillInStackTrace().getMessage());
            }
            Designer.this.xpathResultList.repaint();
            Designer.this.xpathQueryArea.requestFocus();
        }
    }

    private class DFAListener
    implements ActionListener {
        private DFAListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                DFAGraphRule dfaGraphRule = new DFAGraphRule();
                RuleSet rs = new RuleSet();
                SourceType sourceType = Designer.this.getSourceType();
                if (!sourceType.equals(SourceType.JSP)) {
                    rs.addRule(dfaGraphRule);
                }
                RuleContext ctx = new RuleContext();
                ctx.setSourceCodeFilename("[no filename]");
                StringReader reader = new StringReader(Designer.this.codeEditorPane.getText());
                PMD pmd = new PMD();
                pmd.setJavaVersion(Designer.this.getSourceType());
                pmd.processFile((Reader)reader, rs, ctx);
                List methods = dfaGraphRule.getMethods();
                if (methods != null && !methods.isEmpty()) {
                    Designer.this.dfaPanel.resetTo(methods, Designer.this.codeEditorPane);
                    Designer.this.dfaPanel.repaint();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ShowListener
    implements ActionListener {
        private ShowListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            MyPrintStream ps = new MyPrintStream();
            System.setOut(ps);
            try {
                SimpleNode lastCompilationUnit = Designer.this.getCompilationUnit();
                lastCompilationUnit.dump("");
                Designer.this.astArea.setText(ps.getString());
            }
            catch (ParseException pe) {
                Designer.this.astArea.setText(pe.fillInStackTrace().getMessage());
            }
        }
    }
}

