/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.strings.InefficientStringBuffering;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import org.apache.oro.text.perl.Perl5Util;

public class InsufficientStringBufferDeclaration
extends AbstractRule {
    private static final Set blockParents = new HashSet();
    private final Perl5Util regexp = new Perl5Util();
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTIfStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAdditiveExpression;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLiteral;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTBlockStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFieldDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFormalParameter;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchLabel;

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (!"StringBuffer".equals(node.getNameDeclaration().getTypeImage())) {
            return data;
        }
        SimpleNode rootNode = node;
        int anticipatedLength = 0;
        int constructorLength = 16;
        constructorLength = this.getConstructorLength(node, constructorLength);
        List usage = node.getUsages();
        HashMap blocks = new HashMap();
        for (int ix = 0; ix < usage.size(); ++ix) {
            NameOccurrence no = (NameOccurrence)usage.get(ix);
            SimpleNode n = no.getLocation();
            if (!InefficientStringBuffering.isInStringBufferAppend(n, 3)) {
                if (!no.isOnLeftHandSide()) continue;
                if (constructorLength != -1 && anticipatedLength > constructorLength) {
                    Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength += this.processBlocks(blocks))};
                    this.addViolation(data, (Node)rootNode, param);
                }
                constructorLength = this.getConstructorLength(n, constructorLength);
                rootNode = n;
                anticipatedLength = 0;
            }
            ASTPrimaryExpression s = (ASTPrimaryExpression)n.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTPrimaryExpression == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTPrimaryExpression") : class$net$sourceforge$pmd$ast$ASTPrimaryExpression);
            int numChildren = s.jjtGetNumChildren();
            for (int jx = 0; jx < numChildren; ++jx) {
                SimpleNode sn = (SimpleNode)s.jjtGetChild(jx);
                if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                int thisSize = 0;
                Node block = this.getFirstParentBlock(sn);
                thisSize = this.isAdditive(sn) ? this.processAdditive(sn) : this.processNode(sn);
                if (block != null) {
                    this.storeBlockStatistics(blocks, thisSize, block);
                    continue;
                }
                anticipatedLength += thisSize;
            }
        }
        if (constructorLength != -1 && (anticipatedLength += this.processBlocks(blocks)) > constructorLength) {
            Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength)};
            this.addViolation(data, (Node)rootNode, param);
        }
        return data;
    }

    private void storeBlockStatistics(Map blocks, int thisSize, Node block) {
        Integer x;
        HashMap<Node, Integer> thisBranch;
        Node statement = block.jjtGetParent();
        if ((class$net$sourceforge$pmd$ast$ASTIfStatement == null ? (class$net$sourceforge$pmd$ast$ASTIfStatement = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTIfStatement")) : class$net$sourceforge$pmd$ast$ASTIfStatement).equals(block.jjtGetParent().getClass())) {
            Node possibleStatement = ((SimpleNode)statement).getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTIfStatement == null ? (class$net$sourceforge$pmd$ast$ASTIfStatement = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTIfStatement")) : class$net$sourceforge$pmd$ast$ASTIfStatement);
            while (possibleStatement != null && possibleStatement.getClass().equals(class$net$sourceforge$pmd$ast$ASTIfStatement == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTIfStatement") : class$net$sourceforge$pmd$ast$ASTIfStatement)) {
                statement = possibleStatement;
                possibleStatement = ((SimpleNode)possibleStatement).getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTIfStatement == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTIfStatement") : class$net$sourceforge$pmd$ast$ASTIfStatement);
            }
        }
        if ((thisBranch = (HashMap<Node, Integer>)blocks.get(statement)) == null) {
            thisBranch = new HashMap<Node, Integer>();
            blocks.put(statement, thisBranch);
        }
        if ((x = (Integer)thisBranch.get(block)) != null) {
            thisSize += x.intValue();
        }
        thisBranch.put(statement, new Integer(thisSize));
    }

    private int processBlocks(Map blocks) {
        int anticipatedLength = 0;
        int ifLength = 0;
        Iterator iter = blocks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ifLength = 0;
            Iterator iter2 = ((Map)entry.getValue()).entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry2 = iter2.next();
                Integer value = (Integer)entry2.getValue();
                ifLength = Math.max(ifLength, value);
            }
            anticipatedLength += ifLength;
        }
        return anticipatedLength;
    }

    private int processAdditive(SimpleNode sn) {
        ASTAdditiveExpression additive = (ASTAdditiveExpression)sn.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTAdditiveExpression == null ? (class$net$sourceforge$pmd$ast$ASTAdditiveExpression = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTAdditiveExpression")) : class$net$sourceforge$pmd$ast$ASTAdditiveExpression);
        if (additive == null) {
            return 0;
        }
        int anticipatedLength = 0;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            SimpleNode childNode = (SimpleNode)additive.jjtGetChild(ix);
            ASTLiteral literal = (ASTLiteral)childNode.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTLiteral == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTLiteral") : class$net$sourceforge$pmd$ast$ASTLiteral);
            if (literal == null || literal.getImage() == null) continue;
            anticipatedLength += literal.getImage().length() - 2;
        }
        return anticipatedLength;
    }

    private int processNode(SimpleNode sn) {
        int anticipatedLength = 0;
        ASTPrimaryPrefix xn = (ASTPrimaryPrefix)sn.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTPrimaryPrefix == null ? (class$net$sourceforge$pmd$ast$ASTPrimaryPrefix = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTPrimaryPrefix")) : class$net$sourceforge$pmd$ast$ASTPrimaryPrefix);
        if (xn.jjtGetNumChildren() != 0 && xn.jjtGetChild(0).getClass().equals(class$net$sourceforge$pmd$ast$ASTLiteral == null ? (class$net$sourceforge$pmd$ast$ASTLiteral = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTLiteral")) : class$net$sourceforge$pmd$ast$ASTLiteral)) {
            String str = ((SimpleNode)xn.jjtGetChild(0)).getImage();
            anticipatedLength = this.regexp.match("/^[\"']/", str) ? (anticipatedLength += str.length() - 2) : (str.startsWith("0x") ? ++anticipatedLength : (anticipatedLength += str.length()));
        }
        return anticipatedLength;
    }

    private int getConstructorLength(SimpleNode node, int constructorLength) {
        List literal;
        int iConstructorLength = constructorLength;
        SimpleNode block = (SimpleNode)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTBlockStatement == null ? (class$net$sourceforge$pmd$ast$ASTBlockStatement = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTBlockStatement")) : class$net$sourceforge$pmd$ast$ASTBlockStatement);
        if (block == null) {
            block = (ASTFieldDeclaration)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTFieldDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTFieldDeclaration = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTFieldDeclaration")) : class$net$sourceforge$pmd$ast$ASTFieldDeclaration);
        }
        if (block == null && (block = (ASTFormalParameter)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTFormalParameter == null ? (class$net$sourceforge$pmd$ast$ASTFormalParameter = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTFormalParameter")) : class$net$sourceforge$pmd$ast$ASTFormalParameter)) != null) {
            iConstructorLength = -1;
        }
        if ((literal = block.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTLiteral == null ? (class$net$sourceforge$pmd$ast$ASTLiteral = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTLiteral")) : class$net$sourceforge$pmd$ast$ASTLiteral)).size() == 0) {
            List name = block.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTName == null ? (class$net$sourceforge$pmd$ast$ASTName = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTName")) : class$net$sourceforge$pmd$ast$ASTName);
            if (name.size() != 0) {
                iConstructorLength = -1;
            }
        } else {
            String str;
            iConstructorLength = literal.size() == 1 ? ((str = ((SimpleNode)literal.get(0)).getImage()) == null ? 0 : (this.regexp.match("/^['\"]/", str) ? 16 : Integer.parseInt(str))) : -1;
        }
        return iConstructorLength;
    }

    private boolean isAdditive(SimpleNode n) {
        return n.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTAdditiveExpression == null ? (class$net$sourceforge$pmd$ast$ASTAdditiveExpression = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTAdditiveExpression")) : class$net$sourceforge$pmd$ast$ASTAdditiveExpression).size() >= 1;
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !blockParents.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode != null && (class$net$sourceforge$pmd$ast$ASTIfStatement == null ? (class$net$sourceforge$pmd$ast$ASTIfStatement = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTIfStatement")) : class$net$sourceforge$pmd$ast$ASTIfStatement).equals(parentNode.getClass())) {
            parentNode = lastNode;
        } else if (parentNode != null && parentNode.getClass().equals(class$net$sourceforge$pmd$ast$ASTSwitchStatement == null ? (class$net$sourceforge$pmd$ast$ASTSwitchStatement = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTSwitchStatement")) : class$net$sourceforge$pmd$ast$ASTSwitchStatement)) {
            parentNode = InsufficientStringBufferDeclaration.getSwitchParent(parentNode, lastNode);
        }
        return parentNode;
    }

    private static Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.jjtGetChild(ix);
            if (n.getClass().equals(class$net$sourceforge$pmd$ast$ASTSwitchLabel == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTSwitchLabel") : class$net$sourceforge$pmd$ast$ASTSwitchLabel)) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        blockParents.add(class$net$sourceforge$pmd$ast$ASTIfStatement == null ? (class$net$sourceforge$pmd$ast$ASTIfStatement = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTIfStatement")) : class$net$sourceforge$pmd$ast$ASTIfStatement);
        blockParents.add(class$net$sourceforge$pmd$ast$ASTSwitchStatement == null ? (class$net$sourceforge$pmd$ast$ASTSwitchStatement = InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTSwitchStatement")) : class$net$sourceforge$pmd$ast$ASTSwitchStatement);
    }
}

