/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.SimpleNode;

public class PositionalIteratorRule
extends AbstractRule {
    public Object visit(ASTWhileStatement node, Object data) {
        String exprName;
        if (this.hasNameAsChild((SimpleNode)node.jjtGetChild(0)) && (exprName = this.getName((SimpleNode)node.jjtGetChild(0))).indexOf(".hasNext") != -1 && node.jjtGetNumChildren() > 1) {
            SimpleNode loopBody = (SimpleNode)node.jjtGetChild(1);
            ArrayList names = new ArrayList();
            this.collectNames(this.getVariableName(exprName), names, loopBody);
            int nextCount = 0;
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (name.indexOf(".next") == -1) continue;
                ++nextCount;
            }
            if (nextCount > 1) {
                this.addViolation(data, node);
            }
        }
        return null;
    }

    private String getVariableName(String exprName) {
        return exprName.substring(0, exprName.indexOf(46));
    }

    private void collectNames(String target, List names, SimpleNode node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            if (child.jjtGetNumChildren() > 0) {
                this.collectNames(target, names, child);
                continue;
            }
            if (!(child instanceof ASTName) || child.getImage().indexOf(".") == -1 || !target.equals(this.getVariableName(child.getImage()))) continue;
            names.add(child.getImage());
        }
    }

    private boolean hasNameAsChild(SimpleNode node) {
        if (node.jjtGetNumChildren() > 0) {
            if (node.jjtGetChild(0) instanceof ASTName) {
                return true;
            }
            return this.hasNameAsChild((SimpleNode)node.jjtGetChild(0));
        }
        return false;
    }

    private String getName(SimpleNode node) {
        if (node.jjtGetNumChildren() > 0) {
            if (node.jjtGetChild(0) instanceof ASTName) {
                return ((ASTName)node.jjtGetChild(0)).getImage();
            }
            return this.getName((SimpleNode)node.jjtGetChild(0));
        }
        throw new IllegalArgumentException("Check with hasNameAsChild() first!");
    }
}

