/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimitiveType;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.AccessNode;

public class VariableNamingConventions
extends AbstractRule {
    public static final String SEPARATOR = ",";
    private String[] staticPrefix;
    private String[] staticSuffix;
    private String[] memberPrefix;
    private String[] memberSuffix;

    public Object visit(ASTCompilationUnit node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    protected void init() {
        this.staticPrefix = this.split(this.getStringProperty("staticPrefix"));
        this.staticSuffix = this.split(this.getStringProperty("staticSuffix"));
        this.memberPrefix = this.split(this.getStringProperty("memberPrefix"));
        this.memberSuffix = this.split(this.getStringProperty("memberSuffix"));
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        return this.checkNames(node, data);
    }

    public Object checkNames(AccessNode node, Object data) {
        ASTType childNodeType = (ASTType)node.jjtGetChild(0);
        String varType = "";
        if (childNodeType.jjtGetChild(0) instanceof ASTName) {
            varType = ((ASTName)childNodeType.jjtGetChild(0)).getImage();
        } else if (childNodeType.jjtGetChild(0) instanceof ASTPrimitiveType) {
            varType = ((ASTPrimitiveType)childNodeType.jjtGetChild(0)).getImage();
        }
        if (varType != null && varType.length() > 0) {
            ASTClassOrInterfaceDeclaration c;
            ASTVariableDeclarator childNodeName = (ASTVariableDeclarator)node.jjtGetChild(1);
            ASTVariableDeclaratorId childNodeId = (ASTVariableDeclaratorId)childNodeName.jjtGetChild(0);
            String varName = childNodeId.getImage();
            if (varName.equals("serialVersionUID")) {
                return data;
            }
            if (node.isFinal() && !node.isStatic() && node.jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTClassOrInterfaceDeclaration && !(c = (ASTClassOrInterfaceDeclaration)node.jjtGetParent().jjtGetParent().jjtGetParent()).isInterface()) {
                return data;
            }
            if (node.isStatic() && node.isFinal() || node.jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)node.jjtGetParent().jjtGetParent().jjtGetParent()).isInterface()) {
                if (!varName.equals(varName.toUpperCase())) {
                    this.addViolation(data, childNodeName, "Variables that are final and static should be in all caps.");
                }
                return data;
            }
            String strippedVarName = null;
            strippedVarName = node.isStatic() ? this.normalizeStaticVariableName(varName) : this.normalizeMemberVariableName(varName);
            if (strippedVarName.indexOf("_") >= 0) {
                this.addViolation(data, childNodeName, "Variables that are not final should not contain underscores (except for underscores in standard prefix/suffix).");
            }
            if (Character.isUpperCase(varName.charAt(0))) {
                this.addViolation(data, childNodeName, "Variables should start with a lowercase character");
            }
        }
        return data;
    }

    private String normalizeMemberVariableName(String varName) {
        return this.stripSuffix(this.stripPrefix(varName, this.memberPrefix), this.memberSuffix);
    }

    private String normalizeStaticVariableName(String varName) {
        return this.stripSuffix(this.stripPrefix(varName, this.staticPrefix), this.staticSuffix);
    }

    private String stripSuffix(String varName, String[] suffix) {
        if (suffix != null) {
            for (int i = 0; i < suffix.length; ++i) {
                if (!varName.endsWith(suffix[i])) continue;
                varName = varName.substring(0, varName.length() - suffix[i].length());
                break;
            }
        }
        return varName;
    }

    private String stripPrefix(String varName, String[] prefix) {
        if (prefix == null) {
            return varName;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (!varName.startsWith(prefix[i])) continue;
            return varName.substring(prefix[i].length());
        }
        return varName;
    }

    protected String[] split(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        int index = str.indexOf(SEPARATOR);
        if (index == -1) {
            return new String[]{str};
        }
        ArrayList<String> list = new ArrayList<String>();
        int currPos = 0;
        int len = SEPARATOR.length();
        while (index != -1) {
            list.add(str.substring(currPos, index));
            currPos = index + len;
            index = str.indexOf(SEPARATOR, currPos);
        }
        list.add(str.substring(currPos));
        return list.toArray(new String[list.size()]);
    }
}

