/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class UnusedFormalParameterRule
extends AbstractRule {
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.check(node, data);
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        if (!node.isPrivate() && !this.hasProperty("checkall")) {
            return data;
        }
        if (!node.isNative()) {
            this.check(node, data);
        }
        return data;
    }

    private void check(SimpleNode node, Object data) {
        Node parent = node.jjtGetParent().jjtGetParent().jjtGetParent();
        if (parent instanceof ASTClassOrInterfaceDeclaration && !((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            Map vars = node.getScope().getVariableDeclarations();
            Iterator i = vars.keySet().iterator();
            while (i.hasNext()) {
                VariableNameDeclaration nameDecl = (VariableNameDeclaration)i.next();
                if (!((List)vars.get(nameDecl)).isEmpty()) continue;
                this.addViolation(data, (Node)node, new Object[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", nameDecl.getImage()});
            }
        }
    }
}

