/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;

public class SymbolTableTestRule
extends AbstractRule
implements Rule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Map methods = node.getScope().getEnclosingClassScope().getMethodDeclarations();
        HashSet<String> suffixes = new HashSet<String>();
        Iterator i = methods.keySet().iterator();
        while (i.hasNext()) {
            MethodNameDeclaration mnd = (MethodNameDeclaration)i.next();
            String suffix = this.findSuffix(mnd);
            if (suffix == null) continue;
            if (suffixes.contains(suffix)) {
                this.addViolation(data, mnd.getNode(), suffix);
            }
            suffixes.add(suffix);
        }
        return data;
    }

    private String findSuffix(MethodNameDeclaration mnd) {
        String end = null;
        if (mnd.getImage().startsWith("is")) {
            end = mnd.getImage().substring(2);
        } else if (mnd.getImage().startsWith("get")) {
            end = mnd.getImage().substring(3);
        }
        return end;
    }
}

