/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTPrimitiveType;
import net.sourceforge.pmd.ast.ASTResultType;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class BeanMembersShouldSerializeRule
extends AbstractRule {
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimitiveType;

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map methods = node.getScope().getEnclosingClassScope().getMethodDeclarations();
        ArrayList<ASTMethodDeclarator> getSetMethList = new ArrayList<ASTMethodDeclarator>();
        Iterator i = methods.keySet().iterator();
        while (i.hasNext()) {
            ASTMethodDeclarator mnd = ((MethodNameDeclaration)i.next()).getMethodNameDeclaratorNode();
            if (!this.isBeanAccessor(mnd)) continue;
            getSetMethList.add(mnd);
        }
        Object[] methNameArray = new String[getSetMethList.size()];
        for (int i2 = 0; i2 < getSetMethList.size(); ++i2) {
            methNameArray[i2] = ((ASTMethodDeclarator)getSetMethList.get(i2)).getImage();
        }
        Arrays.sort(methNameArray);
        Map vars = node.getScope().getVariableDeclarations();
        Iterator i3 = vars.keySet().iterator();
        while (i3.hasNext()) {
            boolean hasSetMethod;
            VariableNameDeclaration decl = (VariableNameDeclaration)i3.next();
            if (((List)vars.get(decl)).isEmpty() || decl.getAccessNodeParent().isTransient() || decl.getAccessNodeParent().isStatic()) continue;
            String varName = this.trimIfPrefix(decl.getImage());
            varName = varName.substring(0, 1).toUpperCase() + varName.substring(1, varName.length());
            boolean hasGetMethod = Arrays.binarySearch(methNameArray, "get" + varName) >= 0 || Arrays.binarySearch(methNameArray, "is" + varName) >= 0;
            boolean bl = hasSetMethod = Arrays.binarySearch(methNameArray, "set" + varName) >= 0;
            if (hasGetMethod && hasSetMethod) continue;
            this.addViolation(data, decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private String trimIfPrefix(String img) {
        if (this.getStringProperty("prefix") != null && img.startsWith(this.getStringProperty("prefix"))) {
            return img.substring(this.getStringProperty("prefix").length());
        }
        return img;
    }

    private boolean isBeanAccessor(ASTMethodDeclarator meth) {
        ASTResultType ret;
        List primitives;
        if (meth.getImage().startsWith("get") || meth.getImage().startsWith("set")) {
            return true;
        }
        return meth.getImage().startsWith("is") && !(primitives = (ret = (ASTResultType)meth.jjtGetParent().jjtGetChild(0)).findChildrenOfType(class$net$sourceforge$pmd$ast$ASTPrimitiveType == null ? (class$net$sourceforge$pmd$ast$ASTPrimitiveType = BeanMembersShouldSerializeRule.class$("net.sourceforge.pmd.ast.ASTPrimitiveType")) : class$net$sourceforge$pmd$ast$ASTPrimitiveType)).isEmpty() && ((ASTPrimitiveType)primitives.get(0)).isBoolean();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

