/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa.variableaccess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.StartOrEndDataFlowNode;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class VariableAccessVisitor
extends JavaParserVisitorAdapter {
    public void compute(ASTMethodDeclaration node) {
        if (node.jjtGetParent() instanceof ASTClassOrInterfaceBodyDeclaration) {
            this.computeNow(node);
        }
    }

    public void compute(ASTConstructorDeclaration node) {
        this.computeNow(node);
    }

    private void computeNow(SimpleNode node) {
        IDataFlowNode inode = node.getDataFlowNode();
        List undefinitions = this.markUsages(inode);
        IDataFlowNode firstINode = (IDataFlowNode)inode.getFlow().get(0);
        firstINode.setVariableAccess(undefinitions);
        IDataFlowNode lastINode = (IDataFlowNode)inode.getFlow().get(inode.getFlow().size() - 1);
        lastINode.setVariableAccess(undefinitions);
    }

    private List markUsages(IDataFlowNode inode) {
        ArrayList<VariableAccess> undefinitions = new ArrayList<VariableAccess>();
        Set variableDeclarations = this.collectDeclarations(inode);
        Iterator i = variableDeclarations.iterator();
        while (i.hasNext()) {
            Map declarations = (Map)i.next();
            Iterator j = declarations.keySet().iterator();
            while (j.hasNext()) {
                VariableNameDeclaration vnd = (VariableNameDeclaration)j.next();
                this.addVariableAccess(vnd.getNode().getBeginLine(), new VariableAccess(0, vnd.getImage()), inode.getFlow());
                undefinitions.add(new VariableAccess(2, vnd.getImage()));
                Iterator k = ((List)declarations.get(vnd)).iterator();
                while (k.hasNext()) {
                    this.addAccess(k, inode);
                }
            }
        }
        return undefinitions;
    }

    private Set collectDeclarations(IDataFlowNode inode) {
        HashSet<Map> decls = new HashSet<Map>();
        for (int i = 0; i < inode.getFlow().size(); ++i) {
            IDataFlowNode n = (IDataFlowNode)inode.getFlow().get(i);
            if (n instanceof StartOrEndDataFlowNode || decls.contains(n.getSimpleNode().getScope().getVariableDeclarations())) continue;
            decls.add(n.getSimpleNode().getScope().getVariableDeclarations());
        }
        return decls;
    }

    private void addAccess(Iterator k, IDataFlowNode inode) {
        NameOccurrence occurrence = (NameOccurrence)k.next();
        if (occurrence.isOnLeftHandSide()) {
            this.addVariableAccess(occurrence.getLocation().getBeginLine(), new VariableAccess(0, occurrence.getImage()), inode.getFlow());
        } else if (occurrence.isOnRightHandSide() || !occurrence.isOnLeftHandSide() && !occurrence.isOnRightHandSide()) {
            this.addVariableAccess(occurrence.getLocation().getBeginLine(), new VariableAccess(1, occurrence.getImage()), inode.getFlow());
        }
    }

    private void addVariableAccess(int line, VariableAccess va, List flow) {
        for (int i = 1; i < flow.size(); ++i) {
            IDataFlowNode inode = (IDataFlowNode)flow.get(i);
            if (line != inode.getLine()) continue;
            Vector<VariableAccess> v = new Vector<VariableAccess>();
            v.add(va);
            inode.setVariableAccess(v);
        }
    }
}

