/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa.variableaccess;

public class VariableAccess {
    public static final int DEFINITION = 0;
    public static final int REFERENCING = 1;
    public static final int UNDEFINITION = 2;
    private int accessType;
    private String variableName;

    public VariableAccess(int accessType, String varName) {
        this.accessType = accessType;
        this.variableName = varName.indexOf(".") == -1 ? varName : varName.substring(0, varName.indexOf("."));
    }

    public int getAccessType() {
        return this.accessType;
    }

    public boolean accessTypeMatches(int otherType) {
        return this.accessType == otherType;
    }

    public boolean isDefinition() {
        return this.accessType == 0;
    }

    public boolean isReference() {
        return this.accessType == 1;
    }

    public boolean isUndefinition() {
        return this.accessType == 2;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        if (this.isDefinition()) {
            return "Definition(" + this.variableName + ")";
        }
        if (this.isReference()) {
            return "Reference(" + this.variableName + ")";
        }
        if (this.isUndefinition()) {
            return "Undefinition(" + this.variableName + ")";
        }
        throw new RuntimeException("Access type was never set");
    }
}

