/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa.report;

import java.util.ArrayList;
import net.sourceforge.pmd.dfa.report.ReportVisitor;

public abstract class AbstractReportNode {
    private ArrayList childNodes = new ArrayList();
    private AbstractReportNode parentNode = null;
    private int numberOfViolations;

    public abstract boolean equalsNode(AbstractReportNode var1);

    public AbstractReportNode getFirstChild() {
        if (this.isLeaf()) {
            return null;
        }
        return (AbstractReportNode)this.childNodes.get(0);
    }

    public AbstractReportNode getNextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        int index = this.parentNode.getChildIndex(this);
        if (index < 0) {
            return null;
        }
        if (index >= this.parentNode.childNodes.size() - 1) {
            return null;
        }
        return (AbstractReportNode)this.parentNode.childNodes.get(index + 1);
    }

    private int getChildIndex(AbstractReportNode child) {
        for (int i = 0; i < this.childNodes.size(); ++i) {
            if (!this.childNodes.get(i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    public void addFirst(AbstractReportNode child) {
        this.childNodes.add(0, child);
        child.parentNode = this;
    }

    public void add(AbstractReportNode child) {
        this.childNodes.add(child);
        child.parentNode = this;
    }

    public void addNumberOfViolation(int number) {
        this.numberOfViolations += number;
    }

    public int getNumberOfViolations() {
        return this.numberOfViolations;
    }

    public void childrenAccept(ReportVisitor visitor) {
        for (int i = 0; i < this.childNodes.size(); ++i) {
            AbstractReportNode node = (AbstractReportNode)this.childNodes.get(i);
            node.accept(visitor);
        }
    }

    public void accept(ReportVisitor visitor) {
        visitor.visit(this);
    }

    public AbstractReportNode getChildAt(int arg0) {
        if (arg0 >= 0 && arg0 <= this.childNodes.size() - 1) {
            return (AbstractReportNode)this.childNodes.get(arg0);
        }
        return null;
    }

    public int getChildCount() {
        return this.childNodes.size();
    }

    public AbstractReportNode getParent() {
        return this.parentNode;
    }

    public boolean isLeaf() {
        return this.childNodes.isEmpty();
    }
}

