/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.EmacsRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.PapariTextRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.SummaryHTMLRenderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.VBHTMLRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.renderers.YAHTMLRenderer;
import org.apache.tools.ant.BuildException;

public class Formatter {
    private File toFile;
    private String linkPrefix;
    private String type;
    private boolean toConsole;
    private boolean showSuppressed;

    public void setShowSuppressed(boolean value) {
        this.showSuppressed = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLinkPrefix(String linkPrefix) {
        this.linkPrefix = linkPrefix;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setToConsole(boolean toConsole) {
        this.toConsole = toConsole;
    }

    public void outputReport(Report report, String baseDir) {
        try {
            if (this.toConsole) {
                this.outputReportTo(new BufferedWriter(new OutputStreamWriter(System.out)), report, true);
            }
            if (this.toFile != null) {
                this.outputReportTo(this.getToFileWriter(baseDir), report, false);
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage());
        }
    }

    private void outputReportTo(Writer writer, Report report, boolean consoleRenderer) throws IOException {
        String renderedReport = this.getRenderer(consoleRenderer).render(report) + PMD.EOL;
        writer.write(renderedReport, 0, renderedReport.length());
        writer.close();
    }

    public boolean isNoOutputSupplied() {
        return this.toFile == null && !this.toConsole;
    }

    public String toString() {
        return "file = " + this.toFile + "; renderer = " + this.type;
    }

    /*
     * WARNING - void declaration
     */
    private Renderer getRenderer(boolean consoleRenderer) {
        void var2_2;
        Renderer renderer;
        if (this.type.equals("xml")) {
            renderer = new XMLRenderer();
        } else if (this.type.equals("html")) {
            renderer = new HTMLRenderer(this.linkPrefix);
        } else if (this.type.equals("summaryhtml")) {
            renderer = new SummaryHTMLRenderer();
        } else if (this.type.equals("papari")) {
            renderer = new PapariTextRenderer();
        } else if (this.type.equals("csv")) {
            renderer = new CSVRenderer();
        } else if (this.type.equals("text")) {
            renderer = new TextRenderer();
        } else if (this.type.equals("emacs")) {
            renderer = new EmacsRenderer();
        } else if (this.type.equals("vbhtml")) {
            renderer = new VBHTMLRenderer();
        } else if (this.type.equals("yahtml")) {
            renderer = new YAHTMLRenderer();
        } else if (!this.type.equals("")) {
            try {
                renderer = (Renderer)Class.forName(this.type).newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Unable to instantiate custom formatter: " + this.type);
            }
        } else {
            throw new BuildException("Formatter type must be 'xml', 'text', 'html', 'emacs', 'summaryhtml', 'papari', 'csv', 'vbhtml', 'yahtml', or a class name; you specified " + this.type);
        }
        var2_2.showSuppressedViolations(this.showSuppressed);
        return var2_2;
    }

    private Writer getToFileWriter(String baseDir) throws IOException {
        if (!this.toFile.isAbsolute()) {
            return new BufferedWriter(new FileWriter(new File(baseDir + System.getProperty("file.separator") + this.toFile.getPath())));
        }
        return new BufferedWriter(new FileWriter(this.toFile));
    }
}

