/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class SimpleRuleSetNameMapper {
    private StringBuffer rulesets = new StringBuffer();
    private Map nameMap = new HashMap();

    public SimpleRuleSetNameMapper(String ruleString) {
        this.populateNameMap();
        if (ruleString.indexOf(44) == -1) {
            this.check(ruleString);
            return;
        }
        StringTokenizer st = new StringTokenizer(ruleString, ",");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            this.check(tok);
        }
    }

    public String getRuleSets() {
        return this.rulesets.toString();
    }

    private void check(String name) {
        if (name.indexOf("rulesets") == -1 && this.nameMap.containsKey(name)) {
            this.append((String)this.nameMap.get(name));
        } else {
            this.append(name);
        }
    }

    private void append(String name) {
        if (this.rulesets.length() > 0) {
            this.rulesets.append(",");
        }
        this.rulesets.append(name);
    }

    private void populateNameMap() {
        this.nameMap.put("basic", "rulesets/basic.xml");
        this.nameMap.put("jsp", "rulesets/basic-jsp.xml");
        this.nameMap.put("jsf", "rulesets/basic-jsf.xml");
        this.nameMap.put("braces", "rulesets/braces.xml");
        this.nameMap.put("clone", "rulesets/clone.xml");
        this.nameMap.put("codesize", "rulesets/codesize.xml");
        this.nameMap.put("controversial", "rulesets/controversial.xml");
        this.nameMap.put("coupling", "rulesets/coupling.xml");
        this.nameMap.put("design", "rulesets/design.xml");
        this.nameMap.put("finalizers", "rulesets/finalizers.xml");
        this.nameMap.put("imports", "rulesets/imports.xml");
        this.nameMap.put("j2ee", "rulesets/j2ee.xml");
        this.nameMap.put("junit", "rulesets/junit.xml");
        this.nameMap.put("javabeans", "rulesets/javabeans.xml");
        this.nameMap.put("logging-java", "rulesets/logging-java.xml");
        this.nameMap.put("logging-jakarta", "rulesets/logging-jakarta-commons.xml");
        this.nameMap.put("logging-jakarta-commons", "rulesets/logging-jakarta-commons.xml");
        this.nameMap.put("migrating", "rulesets/migrating.xml");
        this.nameMap.put("naming", "rulesets/naming.xml");
        this.nameMap.put("optimizations", "rulesets/optimizations.xml");
        this.nameMap.put("scratchpad", "rulesets/scratchpad.xml");
        this.nameMap.put("strictexception", "rulesets/strictexception.xml");
        this.nameMap.put("strings", "rulesets/strings.xml");
        this.nameMap.put("sunsecure", "rulesets/sunsecure.xml");
        this.nameMap.put("unusedcode", "rulesets/unusedcode.xml");
        this.nameMap.put("33", "rulesets/releases/33.xml");
        this.nameMap.put("34", "rulesets/releases/34.xml");
        this.nameMap.put("35", "rulesets/releases/35.xml");
        this.nameMap.put("36", "rulesets/releases/36.xml");
    }
}

