/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.InputStreamReader;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.SimpleRuleSetNameMapper;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.EmacsRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.IDEAJRenderer;
import net.sourceforge.pmd.renderers.PapariTextRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.SummaryHTMLRenderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.VBHTMLRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.renderers.YAHTMLRenderer;

public class CommandLineOptions {
    private boolean debugEnabled;
    private String targetJDK = "1.4";
    private boolean shortNamesEnabled;
    private String excludeMarker = "NOPMD";
    private String inputPath;
    private String reportFormat;
    private String ruleSets;
    private String encoding = new InputStreamReader(System.in).getEncoding();
    private boolean checkJavaFiles = true;
    private boolean checkJspFiles = false;
    private String[] args;

    public CommandLineOptions(String[] args) {
        if (args == null || args.length < 3) {
            throw new RuntimeException(this.usage());
        }
        this.inputPath = args[0];
        this.reportFormat = args[1];
        this.ruleSets = new SimpleRuleSetNameMapper(args[2]).getRuleSets();
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-debug")) {
                this.debugEnabled = true;
                continue;
            }
            if (args[i].equals("-shortnames")) {
                this.shortNamesEnabled = true;
                continue;
            }
            if (args[i].equals("-encoding")) {
                this.encoding = args[i + 1];
                continue;
            }
            if (args[i].equals("-targetjdk")) {
                this.targetJDK = args[i + 1];
                continue;
            }
            if (args[i].equals("-excludemarker")) {
                this.excludeMarker = args[i + 1];
                continue;
            }
            if (args[i].equals("-jsp")) {
                this.checkJspFiles = true;
                continue;
            }
            if (!args[i].equals("-nojava")) continue;
            this.checkJavaFiles = false;
        }
    }

    public Renderer createRenderer() {
        if (this.reportFormat.equals("xml")) {
            return new XMLRenderer();
        }
        if (this.reportFormat.equals("ideaj")) {
            return new IDEAJRenderer(this.args);
        }
        if (this.reportFormat.equals("papari")) {
            return new PapariTextRenderer();
        }
        if (this.reportFormat.equals("text")) {
            return new TextRenderer();
        }
        if (this.reportFormat.equals("emacs")) {
            return new EmacsRenderer();
        }
        if (this.reportFormat.equals("csv")) {
            return new CSVRenderer();
        }
        if (this.reportFormat.equals("html")) {
            return new HTMLRenderer();
        }
        if (this.reportFormat.equals("yahtml")) {
            return new YAHTMLRenderer();
        }
        if (this.reportFormat.equals("summaryhtml")) {
            return new SummaryHTMLRenderer();
        }
        if (this.reportFormat.equals("vbhtml")) {
            return new VBHTMLRenderer();
        }
        if (!this.reportFormat.equals("")) {
            try {
                return (Renderer)Class.forName(this.reportFormat).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't find the custom format " + this.reportFormat + ": " + e.getClass().getName());
            }
        }
        throw new IllegalArgumentException("Can't create report with format of " + this.reportFormat);
    }

    public boolean containsCommaSeparatedFileList() {
        return this.inputPath.indexOf(44) != -1;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public String getRulesets() {
        return this.ruleSets;
    }

    public String getExcludeMarker() {
        return this.excludeMarker;
    }

    public boolean debugEnabled() {
        return this.debugEnabled;
    }

    public String getTargetJDK() {
        return this.targetJDK;
    }

    public boolean shortNamesEnabled() {
        return this.shortNamesEnabled;
    }

    public String usage() {
        return PMD.EOL + PMD.EOL + "Mandatory arguments:" + PMD.EOL + "1) A java source code filename or directory" + PMD.EOL + "2) A report format " + PMD.EOL + "3) A ruleset filename or a comma-delimited string of ruleset filenames" + PMD.EOL + PMD.EOL + "For example: " + PMD.EOL + "c:\\> java -jar pmd-" + "3.7" + ".jar c:\\my\\source\\code html unusedcode" + PMD.EOL + PMD.EOL + "Optional arguments that may be put after the mandatory arguments are: " + PMD.EOL + "-debug: prints debugging information " + PMD.EOL + "-targetjdk: specifies a language version to target - 1.3, 1.4, or 1.5" + PMD.EOL + "-encoding: specifies the character set encoding of the source code files PMD is reading (i.e., UTF-8)" + PMD.EOL + "-excludemarker: specifies the String that marks the a line which PMD should ignore; default is NOPMD" + PMD.EOL + "-shortnames: prints shortened filenames in the report" + PMD.EOL + PMD.EOL + "For example: " + PMD.EOL + "c:\\> java -jar pmd-" + "3.7" + ".jar c:\\my\\source\\code text unusedcode,imports -targetjdk 1.5 -debug" + PMD.EOL + "c:\\> java -jar pmd-" + "3.7" + ".jar c:\\my\\source\\code xml basic,design -encoding UTF-8" + PMD.EOL + PMD.EOL;
    }

    public boolean isCheckJavaFiles() {
        return this.checkJavaFiles;
    }

    public boolean isCheckJspFiles() {
        return this.checkJspFiles;
    }
}

