/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileIterable
implements Iterable<String> {
    private LineNumberReader lineReader = null;

    public FileIterable(File file) {
        try {
            this.lineReader = new LineNumberReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.lineReader != null) {
                this.lineReader.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new FileIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileIterator
    implements Iterator<String> {
        private boolean hasNext = true;

        FileIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public String next() {
            String line = null;
            try {
                if (this.hasNext && (line = FileIterable.this.lineReader.readLine()) == null) {
                    this.hasNext = false;
                    line = "";
                }
                return line;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported by " + this.getClass().getName());
        }
    }
}

