/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xpath;

import net.sf.saxon.sxpath.IndependentContext;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.java.xpath.GetCommentOnFunction;
import net.sourceforge.pmd.lang.java.xpath.TypeOfFunction;
import net.sourceforge.pmd.lang.xpath.MatchesFunction;
import net.sourceforge.pmd.lang.xpath.PMDFunctions;

public class Initializer {
    public static void initialize() {
    }

    public static void initialize(IndependentContext context) {
        context.declareNamespace("pmd", "java:" + PMDFunctions.class.getName());
        for (Language language : Language.values()) {
            for (LanguageVersion languageVersion : language.getVersions()) {
                LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
                if (languageVersionHandler == null) continue;
                languageVersionHandler.getXPathHandler().initialize(context);
            }
        }
    }

    private static void initializeGlobal() {
        GetCommentOnFunction.registerSelfInSimpleContext();
        MatchesFunction.registerSelfInSimpleContext();
        TypeOfFunction.registerSelfInSimpleContext();
    }

    private static void initializeLanguages() {
        for (Language language : Language.values()) {
            for (LanguageVersion languageVersion : language.getVersions()) {
                LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
                if (languageVersionHandler == null) continue;
                languageVersionHandler.getXPathHandler().initialize();
            }
        }
    }

    static {
        Initializer.initializeGlobal();
        Initializer.initializeLanguages();
    }
}

