/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.lang.reflect.Method;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractMultiPackagedProperty;
import net.sourceforge.pmd.lang.rule.properties.MethodProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMultiProperty
extends AbstractMultiPackagedProperty<Method[]> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<MethodMultiProperty>(Method[].class, packagedFieldTypesByKey){

        public MethodMultiProperty createWith(Map<String, String> valuesById) {
            return new MethodMultiProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), this.defaultValueIn(valuesById), 1.legalPackageNamesIn(valuesById), 0.0f);
        }
    };

    public MethodMultiProperty(String theName, String theDescription, Method[] theDefaults, String[] legalPackageNames, float theUIOrder) {
        super(theName, theDescription, theDefaults, legalPackageNames, theUIOrder);
    }

    public MethodMultiProperty(String theName, String theDescription, String methodDefaults, String[] legalPackageNames, float theUIOrder) {
        super(theName, theDescription, MethodMultiProperty.methodsFrom(methodDefaults), legalPackageNames, theUIOrder);
    }

    public MethodMultiProperty(String theName, String theDescription, String methodDefaults, Map<String, String> otherParams, float theUIOrder) {
        this(theName, theDescription, MethodMultiProperty.methodsFrom(methodDefaults), MethodMultiProperty.packageNamesIn(otherParams), theUIOrder);
    }

    public static Method[] methodsFrom(String methodsStr) {
        String[] values = StringUtil.substringsOf(methodsStr, '|');
        Method[] methods = new Method[values.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = MethodProperty.methodFrom(values[i], '#', ',');
        }
        return methods;
    }

    @Override
    protected String asString(Object value) {
        return value == null ? "" : MethodProperty.asStringFor((Method)value);
    }

    @Override
    protected String packageNameOf(Object item) {
        Method method = (Method)item;
        return method.getDeclaringClass().getName() + '.' + method.getName();
    }

    @Override
    protected String itemTypeName() {
        return "method";
    }

    @Override
    public Class<Method[]> type() {
        return Method[].class;
    }

    @Override
    public Method[] valueFrom(String valueString) throws IllegalArgumentException {
        return MethodMultiProperty.methodsFrom(valueString);
    }
}

