/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.lang.rule.properties.AbstractProperty;
import net.sourceforge.pmd.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnumeratedProperty<E, T>
extends AbstractProperty<T> {
    protected Map<String, E> choicesByLabel;
    protected Map<E, String> labelsByChoice;
    private String[] orderedLabels;
    protected Object[][] choices;

    public AbstractEnumeratedProperty(String theName, String theDescription, String[] theLabels, E[] theChoices, int[] choiceIndices, float theUIOrder, boolean isMulti) {
        super(theName, theDescription, AbstractEnumeratedProperty.selectionsIn(theLabels, choiceIndices, isMulti), theUIOrder);
        this.choicesByLabel = CollectionUtil.mapFrom(theLabels, theChoices);
        this.labelsByChoice = CollectionUtil.invertedMapFrom(this.choicesByLabel);
        this.orderedLabels = theLabels;
    }

    private static Object selectionsIn(String[] items, int[] selectionIndices, boolean isMulti) {
        String[] selections = new String[selectionIndices.length];
        int maxIdx = items.length - 1;
        for (int i = 0; i < selections.length; ++i) {
            if (i < 0 || i > maxIdx) {
                throw new IllegalArgumentException("Invalid item index: " + i);
            }
            selections[i] = items[selectionIndices[i]];
        }
        return isMulti ? selections : selections[0];
    }

    @Override
    protected String defaultAsString() {
        return this.isMultiValue() ? (String)this.defaultValue() : this.asDelimitedString(this.defaultValue(), '|');
    }

    protected String nonLegalValueMsgFor(Object value) {
        return value + " is not a legal value";
    }

    protected E choiceFrom(String label) {
        E result = this.choicesByLabel.get(label);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException(label);
    }

    @Override
    public Object[][] choices() {
        if (this.choices != null) {
            return this.choices;
        }
        this.choices = new Object[this.orderedLabels.length][2];
        for (int i = 0; i < this.choices.length; ++i) {
            this.choices[i][0] = this.orderedLabels[i];
            this.choices[i][1] = this.choicesByLabel.get(this.orderedLabels[i]);
        }
        this.orderedLabels = null;
        return this.choices;
    }
}

