/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.symboltable.AbstractScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.MethodScope;
import net.sourceforge.pmd.lang.java.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileScope
extends AbstractScope {
    protected Map<ClassNameDeclaration, List<NameOccurrence>> classNames = new HashMap<ClassNameDeclaration, List<NameOccurrence>>();
    private String packageImage;

    public SourceFileScope() {
        this("");
    }

    public SourceFileScope(String image) {
        this.packageImage = image;
    }

    @Override
    public ClassScope getEnclosingClassScope() {
        throw new RuntimeException("getEnclosingClassScope() called on SourceFileScope");
    }

    @Override
    public MethodScope getEnclosingMethodScope() {
        throw new RuntimeException("getEnclosingMethodScope() called on SourceFileScope");
    }

    public String getPackageName() {
        return this.packageImage;
    }

    @Override
    public SourceFileScope getEnclosingSourceFileScope() {
        return this;
    }

    @Override
    public void addDeclaration(ClassNameDeclaration classDecl) {
        this.classNames.put(classDecl, new ArrayList());
    }

    @Override
    public void addDeclaration(MethodNameDeclaration decl) {
        throw new RuntimeException("SourceFileScope.addDeclaration(MethodNameDeclaration decl) called");
    }

    @Override
    public void addDeclaration(VariableNameDeclaration decl) {
        throw new RuntimeException("SourceFileScope.addDeclaration(VariableNameDeclaration decl) called");
    }

    @Override
    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.classNames;
    }

    @Override
    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        throw new RuntimeException("PackageScope.getVariableDeclarations() called");
    }

    @Override
    public NameDeclaration addVariableNameOccurrence(NameOccurrence occ) {
        return null;
    }

    public String toString() {
        return "SourceFileScope: " + this.glomNames(this.classNames.keySet());
    }

    @Override
    protected NameDeclaration findVariableHere(NameOccurrence occ) {
        ImageFinderFunction finder = new ImageFinderFunction(occ.getImage());
        Applier.apply(finder, this.classNames.keySet().iterator());
        return finder.getDecl();
    }
}

