/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.strings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMultiplicativeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.strings.InefficientStringBufferingRule;
import net.sourceforge.pmd.lang.java.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsufficientStringBufferDeclarationRule
extends AbstractJavaRule {
    private static final Set<Class<? extends Node>> BLOCK_PARENTS = new HashSet<Class<? extends Node>>(2);
    public static final int DEFAULT_BUFFER_SIZE = 16;

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (!TypeHelper.isEither(node.getNameDeclaration(), StringBuffer.class, StringBuilder.class)) {
            return data;
        }
        JavaNode rootNode = node;
        int anticipatedLength = 0;
        int constructorLength = 16;
        constructorLength = this.getConstructorLength(node, constructorLength);
        anticipatedLength = this.getInitialLength(node);
        List<NameOccurrence> usage = node.getUsages();
        HashMap<Node, Map<Node, Integer>> blocks = new HashMap<Node, Map<Node, Integer>>();
        for (int ix = 0; ix < usage.size(); ++ix) {
            NameOccurrence no = usage.get(ix);
            JavaNode n = no.getLocation();
            if (!InefficientStringBufferingRule.isInStringBufferOperation(n, 3, "append")) {
                if (!no.isOnLeftHandSide() && !InefficientStringBufferingRule.isInStringBufferOperation(n, 3, "setLength")) continue;
                if (constructorLength != -1 && anticipatedLength > constructorLength) {
                    Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength += this.processBlocks(blocks))};
                    this.addViolation(data, (Node)rootNode, param);
                }
                constructorLength = this.getConstructorLength(n, constructorLength);
                rootNode = n;
                anticipatedLength = this.getInitialLength(node);
            }
            ASTPrimaryExpression s = n.getFirstParentOfType(ASTPrimaryExpression.class);
            int numChildren = s.jjtGetNumChildren();
            for (int jx = 0; jx < numChildren; ++jx) {
                Node sn = s.jjtGetChild(jx);
                if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                int thisSize = 0;
                Node block = this.getFirstParentBlock(sn);
                thisSize = this.isAdditive(sn) ? this.processAdditive(sn) : this.processNode(sn);
                if (block != null) {
                    this.storeBlockStatistics(blocks, thisSize, block);
                    continue;
                }
                anticipatedLength += thisSize;
            }
        }
        if (constructorLength != -1 && (anticipatedLength += this.processBlocks(blocks)) > constructorLength) {
            Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength)};
            this.addViolation(data, (Node)rootNode, param);
        }
        return data;
    }

    private void storeBlockStatistics(Map<Node, Map<Node, Integer>> blocks, int thisSize, Node block) {
        Integer x;
        Map<Node, Integer> thisBranch;
        Node statement = block.jjtGetParent();
        if (block.jjtGetParent() instanceof ASTIfStatement) {
            Node possibleStatement = statement.getFirstParentOfType(ASTIfStatement.class);
            while (possibleStatement instanceof ASTIfStatement) {
                statement = possibleStatement;
                possibleStatement = possibleStatement.getFirstParentOfType(ASTIfStatement.class);
            }
        }
        if ((thisBranch = blocks.get(statement)) == null) {
            thisBranch = new HashMap<Node, Integer>();
            blocks.put(statement, thisBranch);
        }
        if ((x = thisBranch.get(block)) != null) {
            thisSize += x.intValue();
        }
        thisBranch.put(statement, thisSize);
    }

    private int processBlocks(Map<Node, Map<Node, Integer>> blocks) {
        int anticipatedLength = 0;
        int ifLength = 0;
        for (Map.Entry<Node, Map<Node, Integer>> entry : blocks.entrySet()) {
            ifLength = 0;
            for (Map.Entry<Node, Integer> entry2 : entry.getValue().entrySet()) {
                Integer value = entry2.getValue();
                ifLength = Math.max(ifLength, value);
            }
            anticipatedLength += ifLength;
        }
        return anticipatedLength;
    }

    private int processAdditive(Node sn) {
        ASTAdditiveExpression additive = sn.getFirstDescendantOfType(ASTAdditiveExpression.class);
        if (additive == null) {
            return 0;
        }
        int anticipatedLength = 0;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            Node childNode = additive.jjtGetChild(ix);
            ASTLiteral literal = childNode.getFirstDescendantOfType(ASTLiteral.class);
            if (literal == null || literal.getImage() == null) continue;
            anticipatedLength += literal.getImage().length() - 2;
        }
        return anticipatedLength;
    }

    private static final boolean isStringOrCharLiteral(ASTLiteral literal) {
        return literal.isStringLiteral() || literal.isCharLiteral();
    }

    private int processNode(Node sn) {
        ASTPrimaryPrefix xn;
        int anticipatedLength = 0;
        if (sn != null && (xn = sn.getFirstDescendantOfType(ASTPrimaryPrefix.class)) != null && xn.jjtGetNumChildren() != 0 && xn.jjtGetChild(0) instanceof ASTLiteral) {
            ASTLiteral literal = (ASTLiteral)xn.jjtGetChild(0);
            String str = xn.jjtGetChild(0).getImage();
            if (str != null) {
                Node parentNode;
                anticipatedLength = InsufficientStringBufferDeclarationRule.isStringOrCharLiteral(literal) ? (anticipatedLength += str.length() - 2) : (literal.isIntLiteral() && str.startsWith("0x") ? ((parentNode = literal.jjtGetParent().jjtGetParent().jjtGetParent()) instanceof ASTCastExpression && parentNode.getFirstChildOfType(ASTType.class).getType() == Character.TYPE ? ++anticipatedLength : (anticipatedLength += String.valueOf(Long.parseLong(str.substring(2), 16)).length())) : (anticipatedLength += str.length()));
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(3);
        return anticipatedLength;
    }

    private int getConstructorLength(Node node, int constructorLength) {
        ASTAdditiveExpression exp;
        int iConstructorLength = constructorLength;
        Node block = node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null) {
            block = node.getFirstParentOfType(ASTFieldDeclaration.class);
        }
        if (block == null) {
            block = node.getFirstParentOfType(ASTFormalParameter.class);
            if (block != null) {
                iConstructorLength = -1;
            } else {
                return 16;
            }
        }
        if ((exp = block.getFirstDescendantOfType(ASTAdditiveExpression.class)) != null) {
            return 16;
        }
        ASTMultiplicativeExpression mult = block.getFirstDescendantOfType(ASTMultiplicativeExpression.class);
        if (mult != null) {
            return 16;
        }
        List<ASTLiteral> literals = block.findDescendantsOfType(ASTLiteral.class);
        if (literals.isEmpty()) {
            List<ASTName> name = block.findDescendantsOfType(ASTName.class);
            if (!name.isEmpty()) {
                iConstructorLength = -1;
            }
        } else {
            ASTLiteral literal;
            String str;
            iConstructorLength = literals.size() == 1 ? ((str = (literal = literals.get(0)).getImage()) == null ? 0 : (InsufficientStringBufferDeclarationRule.isStringOrCharLiteral(literal) ? 14 + str.length() : (literal.isIntLiteral() && str.startsWith("0x") ? Integer.parseInt(str.substring(2), 16) : Integer.parseInt(str)))) : -1;
        }
        if (iConstructorLength == 0) {
            iConstructorLength = constructorLength == -1 ? 16 : constructorLength;
        }
        return iConstructorLength;
    }

    private int getInitialLength(Node node) {
        ASTLiteral literal;
        String str;
        List<ASTLiteral> literals;
        Node block = node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null && (block = (Node)node.getFirstParentOfType(ASTFieldDeclaration.class)) == null) {
            block = node.getFirstParentOfType(ASTFormalParameter.class);
        }
        if ((literals = block.findDescendantsOfType(ASTLiteral.class)).size() == 1 && (str = (literal = literals.get(0)).getImage()) != null && InsufficientStringBufferDeclarationRule.isStringOrCharLiteral(literal)) {
            return str.length() - 2;
        }
        return 0;
    }

    private boolean isAdditive(Node n) {
        return n.hasDescendantOfType(ASTAdditiveExpression.class);
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !BLOCK_PARENTS.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode instanceof ASTIfStatement) {
            parentNode = lastNode;
        } else if (parentNode instanceof ASTSwitchStatement) {
            parentNode = InsufficientStringBufferDeclarationRule.getSwitchParent(parentNode, lastNode);
        }
        return parentNode;
    }

    private static Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.jjtGetChild(ix);
            if (n instanceof ASTSwitchLabel) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    static {
        BLOCK_PARENTS.add(ASTIfStatement.class);
        BLOCK_PARENTS.add(ASTSwitchStatement.class);
    }
}

