/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.StringMultiProperty;

public class CloseResourceRule
extends AbstractJavaRule {
    private Set<String> types = new HashSet<String>();
    private Set<String> simpleTypes = new HashSet<String>();
    private Set<String> closeTargets = new HashSet<String>();
    private static final StringMultiProperty CLOSE_TARGETS_DESCRIPTOR = new StringMultiProperty("closeTargets", "Methods which may close this resource", new String[0], 1.0f, ',');
    private static final StringMultiProperty TYPES_DESCRIPTOR = new StringMultiProperty("types", "Affected types", new String[]{"java.sql.Connection", "java.sql.Statement", "java.sql.ResultSet"}, 2.0f, ',');

    public CloseResourceRule() {
        this.definePropertyDescriptor(CLOSE_TARGETS_DESCRIPTOR);
        this.definePropertyDescriptor(TYPES_DESCRIPTOR);
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        if (this.closeTargets.isEmpty() && this.getProperty(CLOSE_TARGETS_DESCRIPTOR) != null) {
            this.closeTargets.addAll(Arrays.asList((Object[])this.getProperty(CLOSE_TARGETS_DESCRIPTOR)));
        }
        if (this.types.isEmpty() && this.getProperty(TYPES_DESCRIPTOR) != null) {
            this.types.addAll(Arrays.asList((Object[])this.getProperty(TYPES_DESCRIPTOR)));
        }
        if (this.simpleTypes.isEmpty() && this.getProperty(TYPES_DESCRIPTOR) != null) {
            for (String type : this.getProperty(TYPES_DESCRIPTOR)) {
                this.simpleTypes.add(CloseResourceRule.toSimpleType(type));
            }
        }
        return super.visit(node, data);
    }

    private static String toSimpleType(String fullyQualifiedClassName) {
        int lastIndexOf = fullyQualifiedClassName.lastIndexOf(46);
        if (lastIndexOf > -1) {
            return fullyQualifiedClassName.substring(lastIndexOf + 1);
        }
        return fullyQualifiedClassName;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.checkForResources(node, data);
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.checkForResources(node, data);
        return data;
    }

    private void checkForResources(Node node, Object data) {
        List<ASTLocalVariableDeclaration> vars = node.findDescendantsOfType(ASTLocalVariableDeclaration.class);
        ArrayList<ASTVariableDeclaratorId> ids = new ArrayList<ASTVariableDeclaratorId>();
        for (ASTLocalVariableDeclaration var : vars) {
            ASTClassOrInterfaceType clazz;
            ASTReferenceType ref;
            ASTType type = var.getTypeNode();
            if (!(type.jjtGetChild(0) instanceof ASTReferenceType) || !((ref = (ASTReferenceType)type.jjtGetChild(0)).jjtGetChild(0) instanceof ASTClassOrInterfaceType) || !((clazz = (ASTClassOrInterfaceType)ref.jjtGetChild(0)).getType() != null && this.types.contains(clazz.getType().getName()) || clazz.getType() == null && this.simpleTypes.contains(CloseResourceRule.toSimpleType(clazz.getImage()))) && !this.types.contains(clazz.getImage())) continue;
            ASTVariableDeclaratorId id = var.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
            ids.add(id);
        }
        for (ASTVariableDeclaratorId x : ids) {
            this.ensureClosed((ASTLocalVariableDeclaration)x.jjtGetParent().jjtGetParent(), x, data);
        }
    }

    private void ensureClosed(ASTLocalVariableDeclaration var, ASTVariableDeclaratorId id, Object data) {
        String variableToClose = id.getImage();
        String target = variableToClose + ".close";
        Node n = var;
        while (!(n instanceof ASTBlock) && !(n instanceof ASTConstructorDeclaration)) {
            n = n.jjtGetParent();
        }
        ASTLocalVariableDeclaration top = n;
        List<ASTTryStatement> tryblocks = top.findDescendantsOfType(ASTTryStatement.class);
        boolean closed = false;
        for (ASTTryStatement t : tryblocks) {
            if (t.getBeginLine() <= id.getBeginLine() || !t.hasFinally()) continue;
            ASTBlock f = (ASTBlock)t.getFinally().jjtGetChild(0);
            List<ASTName> names = f.findDescendantsOfType(ASTName.class);
            for (ASTName oName : names) {
                String name = oName.getImage();
                if (!name.equals(target)) continue;
                closed = true;
                break;
            }
            if (closed) break;
            ArrayList exprs = new ArrayList();
            f.findDescendantsOfType(ASTStatementExpression.class, exprs, true);
            for (ASTStatementExpression stmt : exprs) {
                ASTPrimarySuffix oSuffix;
                String suff;
                ASTName prefixName;
                String prefixPlusSuffix;
                ASTPrimaryExpression expr = stmt.getFirstChildOfType(ASTPrimaryExpression.class);
                if (expr == null) continue;
                ASTPrimaryPrefix prefix = expr.getFirstChildOfType(ASTPrimaryPrefix.class);
                ASTPrimarySuffix suffix = expr.getFirstChildOfType(ASTPrimarySuffix.class);
                if (prefix == null || suffix == null) continue;
                if (prefix.getImage() != null ? suffix.getImage() != null && this.closeTargets.contains(prefixPlusSuffix = prefix.getImage() + "." + suffix.getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose)) : (prefixName = prefix.getFirstChildOfType(ASTName.class)) != null && this.closeTargets.contains(prefixName.getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose))) break;
                if (closed) continue;
                ArrayList suffixes = new ArrayList();
                expr.findDescendantsOfType(ASTPrimarySuffix.class, suffixes, true);
                Iterator i$ = suffixes.iterator();
                while (!(!i$.hasNext() || this.closeTargets.contains(suff = (oSuffix = (ASTPrimarySuffix)i$.next()).getImage()) && (closed = this.variableIsPassedToMethod(expr, variableToClose)))) {
                }
            }
            if (!closed) continue;
            break;
        }
        if (!closed) {
            ArrayList returns = new ArrayList();
            top.findDescendantsOfType(ASTReturnStatement.class, returns, true);
            for (ASTReturnStatement returnStatement : returns) {
                ASTName name = returnStatement.getFirstDescendantOfType(ASTName.class);
                if (name == null || !name.getImage().equals(variableToClose)) continue;
                closed = true;
                break;
            }
        }
        if (!closed) {
            ASTType type = var.getFirstChildOfType(ASTType.class);
            ASTReferenceType ref = (ASTReferenceType)type.jjtGetChild(0);
            ASTClassOrInterfaceType clazz = (ASTClassOrInterfaceType)ref.jjtGetChild(0);
            this.addViolation(data, (Node)id, clazz.getImage());
        }
    }

    private boolean variableIsPassedToMethod(ASTPrimaryExpression expr, String variable) {
        ArrayList methodParams = new ArrayList();
        expr.findDescendantsOfType(ASTName.class, methodParams, true);
        for (ASTName pName : methodParams) {
            String paramName = pName.getImage();
            ASTArgumentList parentParam = pName.getFirstParentOfType(ASTArgumentList.class);
            if (!paramName.equals(variable) || parentParam == null) continue;
            return true;
        }
        return false;
    }
}

