/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.comments;

import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.rule.comments.AbstractCommentRule;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;

public class CommentRequiredRule
extends AbstractCommentRule {
    public static final EnumeratedProperty<CommentRequirement> HEADER_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty<CommentRequirement>("headerCommentRequirement", "Header comments", CommentRequirement.labels(), CommentRequirement.values(), 0, 1.0f);
    public static final EnumeratedProperty<CommentRequirement> FIELD_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty<CommentRequirement>("fieldCommentRequirement", "Field comments", CommentRequirement.labels(), CommentRequirement.values(), 0, 2.0f);
    public static final EnumeratedProperty<CommentRequirement> PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty<CommentRequirement>("publicMethodCommentRequirement", "Public method comments", CommentRequirement.labels(), CommentRequirement.values(), 0, 3.0f);
    public static final EnumeratedProperty<CommentRequirement> PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR = new EnumeratedProperty<CommentRequirement>("protectedMethodCommentRequirement", "Protected method comments", CommentRequirement.labels(), CommentRequirement.values(), 0, 4.0f);

    public CommentRequiredRule() {
        this.definePropertyDescriptor(HEADER_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(FIELD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
    }

    public Object visit(ASTCompilationUnit cUnit, Object data) {
        return super.visit(cUnit, data);
    }

    public boolean allCommentsAreIgnored() {
        return this.getProperty(HEADER_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(FIELD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored;
    }

    public String dysfunctionReason() {
        return this.allCommentsAreIgnored() ? "All comment types are ignored" : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CommentRequirement {
        Required("Required"),
        Ignored("Ignored"),
        Unwanted("Unwanted");

        private final String label;

        private CommentRequirement(String theLabel) {
            this.label = theLabel;
        }

        public static String[] labels() {
            String[] labels = new String[CommentRequirement.values().length];
            int i = 0;
            for (CommentRequirement requirement : CommentRequirement.values()) {
                labels[i++] = requirement.label;
            }
            return labels;
        }
    }
}

