/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.benchmark;

import net.sourceforge.pmd.benchmark.Benchmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BenchmarkResult
implements Comparable<BenchmarkResult> {
    public final Benchmark type;
    public final String name;
    private long time;
    private long count;

    public BenchmarkResult(Benchmark type, String name) {
        this.type = type;
        this.name = name;
    }

    public BenchmarkResult(Benchmark type, long time, long count) {
        this(type, type.name);
        this.time = time;
        this.count = count;
    }

    public long getTime() {
        return this.time;
    }

    public long getCount() {
        return this.count;
    }

    public void update(long time, long count) {
        this.time += time;
        this.count += count;
    }

    @Override
    public int compareTo(BenchmarkResult benchmarkResult) {
        int cmp = this.type.index - benchmarkResult.type.index;
        if (cmp == 0) {
            long delta = this.time - benchmarkResult.time;
            cmp = delta > 0L ? 1 : (delta < 0L ? -1 : 0);
        }
        return cmp;
    }
}

