/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import net.sourceforge.pmd.lang.ast.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNodeTreeNodeAdapter
implements TreeNode {
    private Node node;
    private List<TreeNode> children;
    private SimpleNodeTreeNodeAdapter parent;

    public SimpleNodeTreeNodeAdapter(SimpleNodeTreeNodeAdapter parent, Node node) {
        this.parent = parent;
        this.node = node;
    }

    public Node getSimpleNode() {
        return this.node;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.checkChildren();
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.checkChildren();
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        this.checkChildren();
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        this.checkChildren();
        return this.children.isEmpty();
    }

    public Enumeration<TreeNode> children() {
        return Collections.enumeration(this.children);
    }

    private void checkChildren() {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode>(this.node.jjtGetNumChildren());
            for (int i = 0; i < this.node.jjtGetNumChildren(); ++i) {
                this.children.add(new SimpleNodeTreeNodeAdapter(this, this.node.jjtGetChild(i)));
            }
        }
    }

    public String toString() {
        return this.node.toString();
    }
}

