/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractDelimitedProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterMultiProperty
extends AbstractDelimitedProperty<Character[]> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<CharacterMultiProperty>(Character[].class){

        public CharacterMultiProperty createWith(Map<String, String> valuesById) {
            return new CharacterMultiProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), this.defaultValueIn(valuesById), null);
        }
    };

    public CharacterMultiProperty(String theName, String theDescription, Character[] theDefaults, float theUIOrder, char delimiter) {
        super(theName, theDescription, theDefaults, delimiter, theUIOrder);
        if (theDefaults != null) {
            for (int i = 0; i < theDefaults.length; ++i) {
                if (theDefaults[i].charValue() != delimiter) continue;
                throw new IllegalArgumentException("Cannot include the delimiter in the set of defaults");
            }
        }
    }

    public CharacterMultiProperty(String theName, String theDescription, String theDefaults, Map<String, String> otherParams) {
        this(theName, theDescription, CharacterMultiProperty.charsIn(theDefaults, CharacterMultiProperty.delimiterIn(otherParams)), 0.0f, CharacterMultiProperty.delimiterIn(otherParams));
    }

    private static Character[] charsIn(String charString, char delimiter) {
        String[] values = StringUtil.substringsOf(charString, delimiter);
        Character[] chars = new Character[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values.length != 1) {
                throw new IllegalArgumentException("missing/ambiguous character value");
            }
            chars[i] = Character.valueOf(values[i].charAt(0));
        }
        return chars;
    }

    @Override
    public Class<Character[]> type() {
        return Character[].class;
    }

    @Override
    public Character[] valueFrom(String valueString) throws IllegalArgumentException {
        String[] values = StringUtil.substringsOf(valueString, this.multiValueDelimiter());
        Character[] chars = new Character[values.length];
        for (int i = 0; i < values.length; ++i) {
            chars[i] = Character.valueOf(values[i].charAt(0));
        }
        return chars;
    }
}

