/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath.saxon;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.ast.xpath.saxon.AbstractNodeInfo;

public class AttributeNode
extends AbstractNodeInfo {
    protected final Attribute attribute;
    protected final int id;
    protected Value value;

    public AttributeNode(Attribute attribute, int id) {
        this.attribute = attribute;
        this.id = id;
    }

    public int getNodeKind() {
        return 2;
    }

    public String getLocalPart() {
        return this.attribute.getName();
    }

    public String getURI() {
        return "";
    }

    public Value atomize() throws XPathException {
        if (this.value == null) {
            Object v = this.attribute.getValue();
            if (v instanceof String) {
                this.value = new StringValue((CharSequence)((String)v));
            } else if (v instanceof Boolean) {
                this.value = BooleanValue.get((boolean)((Boolean)v));
            } else if (v instanceof Integer) {
                this.value = Int64Value.makeIntegerValue((long)((Integer)v).intValue());
            } else if (v != null) {
                throw new RuntimeException("Unable to create ValueRepresentaton for attribute value: " + v + " of type " + v.getClass());
            }
        }
        return this.value;
    }

    public CharSequence getStringValueCS() {
        return this.attribute.getStringValue();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return this.atomize().iterate();
    }

    public int compareOrder(NodeInfo other) {
        return Integer.signum(this.id - ((AttributeNode)other).id);
    }
}

