/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageVersionDiscoverer {
    private Map<Language, LanguageVersion> languageToLanguageVersion = new HashMap<Language, LanguageVersion>();

    public LanguageVersion setDefaultLanguageVersion(LanguageVersion languageVersion) {
        LanguageVersion currentLanguageVersion = this.languageToLanguageVersion.put(languageVersion.getLanguage(), languageVersion);
        if (currentLanguageVersion == null) {
            currentLanguageVersion = languageVersion.getLanguage().getDefaultVersion();
        }
        return currentLanguageVersion;
    }

    public LanguageVersion getDefaultLanguageVersion(Language language) {
        LanguageVersion languageVersion = this.languageToLanguageVersion.get((Object)language);
        if (languageVersion == null) {
            languageVersion = language.getDefaultVersion();
        }
        return languageVersion;
    }

    public LanguageVersion getDefaultLanguageVersionForFile(File sourceFile) {
        return this.getDefaultLanguageVersionForFile(sourceFile.getName());
    }

    public LanguageVersion getDefaultLanguageVersionForFile(String fileName) {
        List<Language> languages = this.getLanguagesForFile(fileName);
        LanguageVersion languageVersion = null;
        if (!languages.isEmpty()) {
            languageVersion = this.getDefaultLanguageVersion(languages.get(0));
        }
        return languageVersion;
    }

    public List<Language> getLanguagesForFile(File sourceFile) {
        return this.getLanguagesForFile(sourceFile.getName());
    }

    public List<Language> getLanguagesForFile(String fileName) {
        String extension = this.getExtension(fileName);
        return Language.findByExtension(extension);
    }

    private String getExtension(String fileName) {
        String extension = null;
        int extensionIndex = 1 + fileName.lastIndexOf(46);
        if (extensionIndex > 0) {
            extension = fileName.substring(extensionIndex);
        }
        return extension;
    }
}

