/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd.graph;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import net.sourceforge.pmd.dcd.ClassLoaderUtil;
import net.sourceforge.pmd.dcd.asm.TypeSignatureVisitor;
import net.sourceforge.pmd.dcd.graph.ClassNode;
import net.sourceforge.pmd.dcd.graph.MemberNode;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorNode
extends MemberNode<ConstructorNode, Constructor<?>> {
    private WeakReference<Constructor<?>> constructorReference;

    public ConstructorNode(ClassNode classNode, String name, String desc) {
        super(classNode, name, desc);
    }

    public boolean isStaticInitializer() {
        return "<clinit>".equals(this.name);
    }

    public boolean isInstanceInitializer() {
        return "<init>".equals(this.name);
    }

    @Override
    public Constructor<?> getMember() {
        Constructor<?> constructor;
        if ("<clinit>".equals(this.name)) {
            return null;
        }
        Constructor<?> constructor2 = constructor = this.constructorReference == null ? null : (Constructor<?>)this.constructorReference.get();
        if (constructor == null) {
            SignatureReader signatureReader = new SignatureReader(this.desc);
            TypeSignatureVisitor visitor = new TypeSignatureVisitor();
            signatureReader.accept((SignatureVisitor)visitor);
            constructor = ClassLoaderUtil.getConstructor(super.getClassNode().getType(), this.name, visitor.getMethodParameterTypes());
            this.constructorReference = new WeakReference(constructor);
        }
        return constructor;
    }

    @Override
    public String toStringLong() {
        if ("<clinit>".equals(this.name)) {
            return this.name;
        }
        return super.toStringLong();
    }

    @Override
    public int compareTo(ConstructorNode that) {
        int cmp = this.getName().compareTo(that.getName());
        if (cmp == 0 && (cmp = ((Constructor)this.getMember()).getParameterTypes().length - ((Constructor)that.getMember()).getParameterTypes().length) == 0) {
            for (int i = 0; i < ((Constructor)this.getMember()).getParameterTypes().length && (cmp = ((Constructor)this.getMember()).getParameterTypes()[i].getName().compareTo(((Constructor)that.getMember()).getParameterTypes()[i].getName())) == 0; ++i) {
            }
        }
        return cmp;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConstructorNode) {
            ConstructorNode that = (ConstructorNode)obj;
            return super.equals(that);
        }
        return false;
    }
}

