/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.util.FileFinder;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPD {
    private static final int MISSING_FILES = 1;
    private static final int MISSING_ARGS = 2;
    private static final int DUPLICATE_CODE_FOUND = 4;
    private CPDConfiguration configuration;
    private Map<String, SourceCode> source = new TreeMap<String, SourceCode>();
    private CPDListener listener = new CPDNullListener();
    private Tokens tokens = new Tokens();
    private MatchAlgorithm matchAlgorithm;
    private Set<String> current = new HashSet<String>();

    public CPD(CPDConfiguration theConfiguration) {
        this.configuration = theConfiguration;
        TokenEntry.clearImages();
    }

    public void setCpdListener(CPDListener cpdListener) {
        this.listener = cpdListener;
    }

    public void go() {
        this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens, this.configuration.minimumTileSize(), this.listener);
        this.matchAlgorithm.findMatches();
    }

    public Iterator<Match> getMatches() {
        return this.matchAlgorithm.matches();
    }

    public void add(File file) throws IOException {
        this.add(1, file);
    }

    public void addAllInDirectory(String dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(String dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List<File> files) throws IOException {
        for (File f : files) {
            this.add(files.size(), f);
        }
    }

    private void addDirectory(String dir, boolean recurse) throws IOException {
        if (!new File(dir).exists()) {
            throw new FileNotFoundException("Couldn't find directory " + dir);
        }
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.configuration.filenameFilter(), recurse));
    }

    private void add(int fileCount, File file) throws IOException {
        if (this.configuration.skipDuplicates()) {
            String signature = file.getName() + '_' + file.length();
            if (this.current.contains(signature)) {
                System.err.println("Skipping " + file.getAbsolutePath() + " since it appears to be a duplicate file and --skip-duplicate-files is set");
                return;
            }
            this.current.add(signature);
        }
        if (!FilenameUtils.equalsNormalizedOnSystem((String)file.getAbsoluteFile().getCanonicalPath(), (String)file.getAbsolutePath())) {
            System.err.println("Skipping " + file + " since it appears to be a symlink");
            return;
        }
        if (!file.exists()) {
            System.err.println("Skipping " + file + " since it doesn't exist (broken symlink?)");
            return;
        }
        this.listener.addedFile(fileCount, file);
        SourceCode sourceCode = this.configuration.sourceCodeFor(file);
        this.configuration.tokenizer().tokenize(sourceCode, this.tokens);
        this.source.put(sourceCode.getFileName(), sourceCode);
    }

    private static void setSystemProperties(String[] args) {
        boolean ignoreLiterals = CPDConfiguration.findBooleanSwitch(args, "--ignore-literals");
        boolean ignoreIdentifiers = CPDConfiguration.findBooleanSwitch(args, "--ignore-identifiers");
        boolean ignoreAnnotations = CPDConfiguration.findBooleanSwitch(args, "--ignore-annotations");
        Properties properties = System.getProperties();
        if (ignoreLiterals) {
            properties.setProperty("ignore_literals", "true");
        }
        if (ignoreIdentifiers) {
            properties.setProperty("ignore_identifiers", "true");
        }
        if (ignoreAnnotations) {
            properties.setProperty("ignore_annotations", "true");
        }
        System.setProperties(properties);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CPD.showUsage();
            System.exit(2);
        }
        try {
            CPDConfiguration config = new CPDConfiguration(args);
            CPD.setSystemProperties(args);
            CPD cpd = new CPD(config);
            boolean missingFiles = true;
            for (int position = 0; position < args.length; ++position) {
                if (!args[position].equals("--files")) continue;
                cpd.addRecursively(args[position + 1]);
                if (!missingFiles) continue;
                missingFiles = false;
            }
            if (missingFiles) {
                System.out.println("No --files value passed in");
                CPD.showUsage();
                System.exit(1);
            }
            cpd.go();
            if (cpd.getMatches().hasNext()) {
                System.out.println(config.renderer().render(cpd.getMatches()));
                System.exit(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showUsage() {
        System.out.println("Usage:");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens xxx --files xxx [--language xxx] [--encoding xxx] [--format (xml|text|csv|vs)] [--skip-duplicate-files] ");
        System.out.println("i.e: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files c:\\jdk14\\src\\java ");
        System.out.println("or: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files /path/to/c/code --language c ");
        System.out.println("or: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --encoding UTF-16LE --files /path/to/java/code --format xml");
    }
}

