/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.ant.Formatter;
import net.sourceforge.pmd.ant.RuleSetWrapper;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.FileDataSource;
import net.sourceforge.pmd.util.log.AntLogHandler;
import net.sourceforge.pmd.util.log.ScopedLogHandlersManager;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PMDTask
extends Task {
    private Path classpath;
    private Path auxClasspath;
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final PMDConfiguration configuration = new PMDConfiguration();
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private int maxRuleViolations = 0;
    private String failuresPropertyName;
    private final Collection<RuleSetWrapper> nestedRules = new ArrayList<RuleSetWrapper>();

    public void setShortFilenames(boolean reportShortNames) {
        this.configuration.setReportShortNames(reportShortNames);
    }

    public void setSuppressMarker(String suppressMarker) {
        this.configuration.setSuppressMarker(suppressMarker);
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setFailOnRuleViolation(boolean fail) {
        this.failOnRuleViolation = fail;
    }

    public void setMaxRuleViolations(int max) {
        if (max >= 0) {
            this.maxRuleViolations = max;
            this.failOnRuleViolation = true;
        }
    }

    public void setRuleSetFiles(String ruleSets) {
        this.configuration.setRuleSets(ruleSets);
    }

    public void setEncoding(String sourceEncoding) {
        this.configuration.setSourceEncoding(sourceEncoding);
    }

    public void setThreads(int threads) {
        this.configuration.setThreads(threads);
    }

    public void setFailuresPropertyName(String failuresPropertyName) {
        this.failuresPropertyName = failuresPropertyName;
    }

    public void setMinimumPriority(int minPriority) {
        this.configuration.setMinimumPriority(RulePriority.valueOf(minPriority));
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addFormatter(Formatter f) {
        this.formatters.add(f);
    }

    public void addConfiguredSourceLanguage(SourceLanguage version) {
        LanguageVersion languageVersion = LanguageVersion.findVersionsForLanguageTerseName(version.getName(), version.getVersion());
        if (languageVersion == null) {
            throw new BuildException("The following language is not supported:" + version + ".");
        }
        this.configuration.setDefaultLanguageVersion(languageVersion);
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setAuxClasspath(Path auxClasspath) {
        this.auxClasspath = auxClasspath;
    }

    public Path getAuxClasspath() {
        return this.auxClasspath;
    }

    public Path createAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.getProject());
        }
        return this.auxClasspath.createPath();
    }

    public void setAuxClasspathRef(Reference r) {
        this.createAuxClasspath().setRefid(r);
    }

    private void doTask() {
        this.setupClassLoader();
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        ruleSetFactory.setClassLoader(this.configuration.getClassLoader());
        try {
            ruleSetFactory.setMinimumPriority(this.configuration.getMinimumPriority());
            ruleSetFactory.setWarnDeprecated(true);
            String ruleSets = this.configuration.getRuleSets();
            if (StringUtil.isNotEmpty(ruleSets)) {
                this.configuration.setRuleSets(this.getProject().replaceProperties(ruleSets));
            }
            RuleSets rules = ruleSetFactory.createRuleSets(this.configuration.getRuleSets());
            ruleSetFactory.setWarnDeprecated(false);
            this.logRulesUsed(rules);
        }
        catch (RuleSetNotFoundException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        if (this.configuration.getSuppressMarker() != null) {
            this.log("Setting suppress marker to be " + this.configuration.getSuppressMarker(), 3);
        }
        for (Formatter formatter : this.formatters) {
            this.log("Sending a report to " + formatter, 3);
            formatter.start(this.getProject().getBaseDir().toString());
        }
        RuleContext ctx = new RuleContext();
        Report errorReport = new Report();
        final AtomicInteger reportSize = new AtomicInteger();
        String separator = System.getProperty("file.separator");
        for (FileSet fs : this.filesets) {
            String[] srcFiles;
            LinkedList<DataSource> files = new LinkedList<DataSource>();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            for (String srcFile : srcFiles = ds.getIncludedFiles()) {
                File file = new File(ds.getBasedir() + separator + srcFile);
                files.add(new FileDataSource(file));
            }
            final String inputPaths = ds.getBasedir().getPath();
            this.configuration.setInputPaths(inputPaths);
            AbstractRenderer logRenderer = new AbstractRenderer("log", "Logging renderer"){

                public void start() {
                }

                public void startFileAnalysis(DataSource dataSource) {
                    PMDTask.this.log("Processing file " + dataSource.getNiceFileName(false, inputPaths), 3);
                }

                public void renderFileReport(Report r) {
                    int size = r.size();
                    if (size > 0) {
                        reportSize.addAndGet(size);
                    }
                }

                public void end() {
                }

                public String defaultFileExtension() {
                    return null;
                }
            };
            LinkedList<Renderer> renderers = new LinkedList<Renderer>();
            renderers.add(logRenderer);
            for (Formatter formatter : this.formatters) {
                renderers.add(formatter.getRenderer());
            }
            try {
                PMD.processFiles(this.configuration, ruleSetFactory, files, ctx, renderers);
            }
            catch (RuntimeException pmde) {
                this.handleError(ctx, errorReport, pmde);
            }
        }
        int problemCount = reportSize.get();
        this.log(problemCount + " problems found", 3);
        for (Formatter formatter : this.formatters) {
            formatter.end(errorReport);
        }
        if (this.failuresPropertyName != null && problemCount > 0) {
            this.getProject().setProperty(this.failuresPropertyName, String.valueOf(problemCount));
            this.log("Setting property " + this.failuresPropertyName + " to " + problemCount, 3);
        }
        if (this.failOnRuleViolation && problemCount > this.maxRuleViolations) {
            throw new BuildException("Stopping build since PMD found " + problemCount + " rule violations in the code");
        }
    }

    private void handleError(RuleContext ctx, Report errorReport, RuntimeException pmde) {
        pmde.printStackTrace();
        this.log(pmde.toString(), 3);
        Throwable cause = pmde.getCause();
        if (cause != null) {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            cause.printStackTrace(printWriter);
            this.log(strWriter.toString(), 3);
            IOUtil.closeQuietly(printWriter);
            if (StringUtil.isNotEmpty(cause.getMessage())) {
                this.log(cause.getMessage(), 3);
            }
        }
        if (this.failOnError) {
            throw new BuildException((Throwable)pmde);
        }
        errorReport.addError(new Report.ProcessingError(pmde.getMessage(), ctx.getSourceCodeFilename()));
    }

    private void setupClassLoader() {
        if (this.classpath == null) {
            this.log("Using the normal ClassLoader", 3);
        } else {
            this.log("Using the AntClassLoader", 3);
            boolean parentFirst = true;
            this.configuration.setClassLoader((ClassLoader)new AntClassLoader(Thread.currentThread().getContextClassLoader(), this.getProject(), this.classpath, parentFirst));
        }
        try {
            this.configuration.prependClasspath(this.getProject().getBaseDir().toString());
            if (this.auxClasspath != null) {
                this.log("Using auxclasspath: " + this.auxClasspath, 3);
                this.configuration.prependClasspath(this.auxClasspath.toString());
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.validate();
        AntLogHandler antLogHandler = new AntLogHandler(this);
        ScopedLogHandlersManager logManager = new ScopedLogHandlersManager(Level.FINEST, antLogHandler);
        try {
            this.doTask();
        }
        finally {
            logManager.close();
        }
    }

    private void logRulesUsed(RuleSets rules) {
        RuleSet[] ruleSets;
        this.log("Using these rulesets: " + this.configuration.getRuleSets(), 3);
        for (RuleSet ruleSet : ruleSets = rules.getAllRuleSets()) {
            for (Rule rule : ruleSet.getRules()) {
                this.log("Using rule " + rule.getName(), 3);
            }
        }
    }

    private void validate() throws BuildException {
        if (this.formatters.isEmpty()) {
            Formatter defaultFormatter = new Formatter();
            defaultFormatter.setType("text");
            defaultFormatter.setToConsole(true);
            this.formatters.add(defaultFormatter);
        } else {
            for (Formatter f : this.formatters) {
                if (!f.isNoOutputSupplied()) continue;
                throw new BuildException("toFile or toConsole needs to be specified in Formatter");
            }
        }
        if (this.configuration.getRuleSets() == null) {
            if (this.nestedRules.isEmpty()) {
                throw new BuildException("No rulesets specified");
            }
            this.configuration.setRuleSets(this.getNestedRuleSetFiles());
        }
    }

    private String getNestedRuleSetFiles() {
        StringBuilder sb = new StringBuilder();
        Iterator<RuleSetWrapper> it = this.nestedRules.iterator();
        while (it.hasNext()) {
            RuleSetWrapper rs = it.next();
            sb.append(rs.getFile());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public void addRuleset(RuleSetWrapper r) {
        this.nestedRules.add(r);
    }
}

