/**
 * Last modified: Aug 08 2004
 *
 * @author Takayuki Hoshi <hoshi103@chapman.edu>
 * File: SystemRM3.java
 * 
System: RM3

This is exactly the same as LP except for => and <=> so that MP is valid in RM3
 * 
 */
 
public class SystemRM3 {

/*
 * Translates a truth value to english
 */
	public static String truthValueToEnglish( int a ) {
		/* 1 -> True, 0 -> False CONVERSION */
		if (a == 0) {
			return "False" ;
		}
		else if ( a == 1 ) {
			return "True" ;
		}
		else		// !! this is the change (from K3)
			return "True" ;
// 		else return "Unsupported truth value found in the formula." ;
	}
		
/*
 * [ ~x ] 
 */
		public static int interpretNot( int x ) {
			if ( x == 1 ) return 0;
			else if ( x == 0 ) return 1;
			else return 2;
		}
		
/*
 * [ x & y ] 
 */
		
		public static int interpretAnd( int x, int y ) {
			if ( x == 1 &&  y == 1 ) return 1;
			else if ( x == 0 || y == 0) return 0;
			else return 2;
		}
		
		
/*
 * [ x | y ] 
 */
		public static int interpretOr( int x, int y ) {
			if ( x == 0 &&  y == 0 ) return 0;
			else if ( x == 1 || y == 1) return 1;
			else return 2;
		}
		
/*
 * [ x => y ] 
 */
		public static int interpretImplies( int x, int y ) {
			if ( x == 0 || y == 1) return 1;
// 			else if ( x == 1 && y == 0 ) return 0;
// 			else return 2;
			else if ( x == 2 && y == 2) return 2;
			else return 0;
		}
		
/*
 * [ x <=> y ] 
 */
		public static int interpretIff( int x, int y ) {
			return 
				interpretAnd ( 
					interpretImplies( x, y ), interpretImplies( y, x ) );
		}
		
}		// end of class `SystemRM3'
