/**
 * Last modified: Aug 05 2004
 *
 * @author Takayuki Hoshi <hoshi103@chapman.edu>
 * File: SystemLP.java
 * 
System: Logic of Paradox ( LP)

 * TV = { 0, u, 1 } = { 0, 2, 1}
 * D = { 1, 2 }
 * C = { ~, &, |, =>, <=> }
 * 
 * Here, LP interprets `2' as "both true and false"; 1 as "true and true only";
 * and 0 as "false and false only".
 */
 
/* Note that in this class, we are assuming that the truth value passed to each
 * function is necessarily either 0, 1 or 2.  */
public class SystemLP {

/*
 * Translates a truth value to english
 */
	public static String truthValueToEnglish( int a ) {
		/* 1 -> True, 0 -> False CONVERSION */
		if (a == 0) {
			return "False" ;
		}
		else if ( a == 1 ) {
			return "True" ;
		}
		else		// !! this is the change (from K3)
			return "True" ;
// 		else return "Unsupported truth value found in the formula." ;
	}
		
/*
 * [ ~x ] 
 */
		public static int interpretNot( int x ) {
			if ( x == 1 ) return 0;
			else if ( x == 0 ) return 1;
			else return 2;
		}
		
/*
 * [ x & y ] 
 */
		
		public static int interpretAnd( int x, int y ) {
			if ( x == 1 &&  y == 1 ) return 1;
			else if ( x == 0 || y == 0) return 0;
			else return 2;
		}
		
		
/*
 * [ x | y ] 
 */
		public static int interpretOr( int x, int y ) {
			if ( x == 0 &&  y == 0 ) return 0;
			else if ( x == 1 || y == 1) return 1;
			else return 2;
		}
		
/*
 * [ x => y ] 
 */
		public static int interpretImplies( int x, int y ) {
			if ( x == 0 || y == 1) return 1;
			else if ( x == 1 && y == 0 ) return 0;
			else return 2;
		}
		
/*
 * [ x <=> y ] 
 */
		public static int interpretIff( int x, int y ) {
			return 
				interpretAnd ( 
					interpretImplies( x, y ), interpretImplies( y, x ) );
		}
		
}		// end of class `SystemLP'
