/**
 * Last modified: Aug 05 2004
 *
 * @author Takayuki Hoshi <hoshi103@chapman.edu>
 * File: SystemL.java
 * 
System of fuzzy logic called L.
 *
 */
 
public class SystemL {


/*
 * Translates a truth value to english
 */
	public static String truthValueToEnglish( double a ) {
		/* 1 -> True, 0 -> False CONVERSION */
		if (a == 1.0) {
			return "True" ;
		}
		else return "False" ;
	}
		
/*
 * [ ~x ] 
 */
		public static double interpretNot( double x ) {
			return 1.0 - x;
		}
		
/*
 * [ x & y ] 
 */
		public static double interpretAnd( double x, double y ) {
			return Math.min(x, y);
		}
		
/*
 * [ x | y ] 
 */
		public static double interpretOr( double x, double y ) {
			return Math.max(x, y);
		}
		
/*
 * [ x => y ] 
 */
		public static double interpretImplies( double x, double y ) {
			if ( x <= y ) return 1.0;
			else return 1.0 - ( x - y );
		}
		
/*
 * [ x <=> y ] 
 */
		public static double interpretIff( double x, double y ) {
			return 
				interpretAnd ( 
					interpretImplies( x, y ), interpretImplies( y, x ) );
		}
		


}		// end of class `SystemL'
