/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class PatternSet
extends DataType
implements Cloneable {
    private Vector includeList = new Vector();
    private Vector excludeList = new Vector();
    private Vector includesFileList = new Vector();
    private Vector excludesFileList = new Vector();

    public void setRefid(Reference r) throws BuildException {
        if (!this.includeList.isEmpty() || !this.excludeList.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public void addConfiguredPatternset(PatternSet p) {
        int i;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        String[] nestedIncludes = p.getIncludePatterns(this.getProject());
        String[] nestedExcludes = p.getExcludePatterns(this.getProject());
        if (nestedIncludes != null) {
            i = 0;
            while (i < nestedIncludes.length) {
                this.createInclude().setName(nestedIncludes[i]);
                ++i;
            }
        }
        if (nestedExcludes != null) {
            i = 0;
            while (i < nestedExcludes.length) {
                this.createExclude().setName(nestedExcludes[i]);
                ++i;
            }
        }
    }

    public NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includeList);
    }

    public NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includesFileList);
    }

    public NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludeList);
    }

    public NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludesFileList);
    }

    public void setIncludes(String includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (includes != null && includes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(includes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createInclude().setName(tok.nextToken());
            }
        }
    }

    public void setExcludes(String excludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (excludes != null && excludes.length() > 0) {
            StringTokenizer tok = new StringTokenizer(excludes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName(tok.nextToken());
            }
        }
    }

    private NameEntry addPatternToList(Vector list) {
        NameEntry result = new NameEntry();
        list.addElement(result);
        return result;
    }

    public void setIncludesfile(File includesFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createIncludesFile().setName(includesFile.getAbsolutePath());
    }

    public void setExcludesfile(File excludesFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createExcludesFile().setName(excludesFile.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPatterns(File patternfile, Vector patternlist, Project p) throws BuildException {
        BufferedReader patternReader = null;
        try {
            try {
                patternReader = new BufferedReader(new FileReader(patternfile));
                String line = patternReader.readLine();
                while (line != null) {
                    if (line.length() > 0) {
                        line = p.replaceProperties(line);
                        this.addPatternToList(patternlist).setName(line);
                    }
                    line = patternReader.readLine();
                }
            }
            catch (IOException ioe) {
                String msg = "An error occured while reading from pattern file: " + patternfile;
                throw new BuildException(msg, ioe);
            }
            Object var8_7 = null;
            if (null == patternReader) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == patternReader) throw throwable;
            try {
                patternReader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        patternReader.close();
        return;
    }

    public void append(PatternSet other, Project p) {
        String[] excl;
        if (this.isReference()) {
            throw new BuildException("Cannot append to a reference");
        }
        String[] incl = other.getIncludePatterns(p);
        if (incl != null) {
            int i = 0;
            while (i < incl.length) {
                this.createInclude().setName(incl[i]);
                ++i;
            }
        }
        if ((excl = other.getExcludePatterns(p)) != null) {
            int i = 0;
            while (i < excl.length) {
                this.createExclude().setName(excl[i]);
                ++i;
            }
        }
    }

    public String[] getIncludePatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getIncludePatterns(p);
        }
        this.readFiles(p);
        return this.makeArray(this.includeList, p);
    }

    public String[] getExcludePatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getExcludePatterns(p);
        }
        this.readFiles(p);
        return this.makeArray(this.excludeList, p);
    }

    boolean hasPatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).hasPatterns(p);
        }
        return this.includesFileList.size() > 0 || this.excludesFileList.size() > 0 || this.includeList.size() > 0 || this.excludeList.size() > 0;
    }

    private PatternSet getRef(Project p) {
        Object o;
        if (!this.isChecked()) {
            Stack<PatternSet> stk = new Stack<PatternSet>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        if (!((o = this.getRefid().getReferencedObject(p)) instanceof PatternSet)) {
            String msg = this.getRefid().getRefId() + " doesn't denote a patternset";
            throw new BuildException(msg);
        }
        return (PatternSet)o;
    }

    private String[] makeArray(Vector list, Project p) {
        if (list.size() == 0) {
            return null;
        }
        Vector<String> tmpNames = new Vector<String>();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            NameEntry ne = (NameEntry)e.nextElement();
            String pattern = ne.evalName(p);
            if (pattern == null || pattern.length() <= 0) continue;
            tmpNames.addElement(pattern);
        }
        Object[] result = new String[tmpNames.size()];
        tmpNames.copyInto(result);
        return result;
    }

    private void readFiles(Project p) {
        String fileName;
        NameEntry ne;
        Enumeration e;
        if (this.includesFileList.size() > 0) {
            e = this.includesFileList.elements();
            while (e.hasMoreElements()) {
                ne = (NameEntry)e.nextElement();
                fileName = ne.evalName(p);
                if (fileName == null) continue;
                File inclFile = p.resolveFile(fileName);
                if (!inclFile.exists()) {
                    throw new BuildException("Includesfile " + inclFile.getAbsolutePath() + " not found.");
                }
                this.readPatterns(inclFile, this.includeList, p);
            }
            this.includesFileList.removeAllElements();
        }
        if (this.excludesFileList.size() > 0) {
            e = this.excludesFileList.elements();
            while (e.hasMoreElements()) {
                ne = (NameEntry)e.nextElement();
                fileName = ne.evalName(p);
                if (fileName == null) continue;
                File exclFile = p.resolveFile(fileName);
                if (!exclFile.exists()) {
                    throw new BuildException("Excludesfile " + exclFile.getAbsolutePath() + " not found.");
                }
                this.readPatterns(exclFile, this.excludeList, p);
            }
            this.excludesFileList.removeAllElements();
        }
    }

    public String toString() {
        return "patternSet{ includes: " + this.includeList + " excludes: " + this.excludeList + " }";
    }

    public Object clone() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).clone();
        }
        try {
            PatternSet ps = (PatternSet)super.clone();
            ps.includeList = (Vector)this.includeList.clone();
            ps.excludeList = (Vector)this.excludeList.clone();
            ps.includesFileList = (Vector)this.includesFileList.clone();
            ps.excludesFileList = (Vector)this.excludesFileList.clone();
            return ps;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    public class NameEntry {
        private String name;
        private String ifCond;
        private String unlessCond;

        public void setName(String name) {
            this.name = name;
        }

        public void setIf(String cond) {
            this.ifCond = cond;
        }

        public void setUnless(String cond) {
            this.unlessCond = cond;
        }

        public String getName() {
            return this.name;
        }

        public String evalName(Project p) {
            return this.valid(p) ? this.name : null;
        }

        private boolean valid(Project p) {
            if (this.ifCond != null && p.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || p.getProperty(this.unlessCond) == null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.name);
            if (this.ifCond != null || this.unlessCond != null) {
                buf.append(":");
                String connector = "";
                if (this.ifCond != null) {
                    buf.append("if->");
                    buf.append(this.ifCond);
                    connector = ";";
                }
                if (this.unlessCond != null) {
                    buf.append(connector);
                    buf.append("unless->");
                    buf.append(this.unlessCond);
                }
            }
            return buf.toString();
        }
    }
}

