/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.Gcj;
import org.apache.tools.ant.taskdefs.compilers.Javac12;
import org.apache.tools.ant.taskdefs.compilers.Javac13;
import org.apache.tools.ant.taskdefs.compilers.JavacExternal;
import org.apache.tools.ant.taskdefs.compilers.Jikes;
import org.apache.tools.ant.taskdefs.compilers.Jvc;
import org.apache.tools.ant.taskdefs.compilers.Kjc;
import org.apache.tools.ant.taskdefs.compilers.Sj;
import org.apache.tools.ant.util.JavaEnvUtils;

public class CompilerAdapterFactory {
    private static final String MODERN_COMPILER = "com.sun.tools.javac.Main";
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$compilers$CompilerAdapterFactory;

    private CompilerAdapterFactory() {
    }

    public static CompilerAdapter getCompiler(String compilerType, Task task) throws BuildException {
        boolean isClassicCompilerSupported = true;
        if (JavaEnvUtils.isJavaVersion("1.4")) {
            isClassicCompilerSupported = false;
        }
        if (compilerType.equalsIgnoreCase("jikes")) {
            return new Jikes();
        }
        if (compilerType.equalsIgnoreCase("extJavac")) {
            return new JavacExternal();
        }
        if (compilerType.equalsIgnoreCase("classic") || compilerType.equalsIgnoreCase("javac1.1") || compilerType.equalsIgnoreCase("javac1.2")) {
            if (isClassicCompilerSupported) {
                return new Javac12();
            }
            task.log("This version of java does not support the classic compiler; upgrading to modern", 1);
            compilerType = "modern";
        }
        if (compilerType.equalsIgnoreCase("modern") || compilerType.equalsIgnoreCase("javac1.3") || compilerType.equalsIgnoreCase("javac1.4")) {
            if (CompilerAdapterFactory.doesModernCompilerExist()) {
                return new Javac13();
            }
            if (isClassicCompilerSupported) {
                task.log("Modern compiler not found - looking for classic compiler", 1);
                return new Javac12();
            }
            throw new BuildException("Unable to find a javac compiler;\ncom.sun.tools.javac.Main is not on the classpath.\nPerhaps JAVA_HOME does not point to the JDK");
        }
        if (compilerType.equalsIgnoreCase("jvc") || compilerType.equalsIgnoreCase("microsoft")) {
            return new Jvc();
        }
        if (compilerType.equalsIgnoreCase("kjc")) {
            return new Kjc();
        }
        if (compilerType.equalsIgnoreCase("gcj")) {
            return new Gcj();
        }
        if (compilerType.equalsIgnoreCase("sj") || compilerType.equalsIgnoreCase("symantec")) {
            return new Sj();
        }
        return CompilerAdapterFactory.resolveClassName(compilerType);
    }

    private static boolean doesModernCompilerExist() {
        try {
            Class.forName(MODERN_COMPILER);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            try {
                (class$org$apache$tools$ant$taskdefs$compilers$CompilerAdapterFactory == null ? (class$org$apache$tools$ant$taskdefs$compilers$CompilerAdapterFactory = CompilerAdapterFactory.class$("org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory")) : class$org$apache$tools$ant$taskdefs$compilers$CompilerAdapterFactory).getClassLoader().loadClass(MODERN_COMPILER);
                return true;
            }
            catch (ClassNotFoundException cnfe2) {
                return false;
            }
        }
    }

    private static CompilerAdapter resolveClassName(String className) throws BuildException {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            return (CompilerAdapter)o;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException("Compiler Adapter '" + className + "' can't be found.", cnfe);
        }
        catch (ClassCastException cce) {
            throw new BuildException(className + " isn't the classname of " + "a compiler adapter.", cce);
        }
        catch (Throwable t) {
            throw new BuildException("Compiler Adapter " + className + " caused an interesting exception.", t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

