/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import java.util.Vector;

public class ThreeValuedLister {
    public static final boolean DEBUG = false;
    public static final boolean CLASSICAL = true;
    private PropositionalLogicParser parser;
    private Vector vector;
    private int nElements;
    private String formula = "";
    private int limit;
    private int[] answers;
    private String[] keys;
    private String[][] possibilities;

    public ThreeValuedLister(String string, Vector vector, PropositionalLogicParser propositionalLogicParser) {
        this.vector = vector;
        this.nElements = vector.size();
        this.formula = string;
        this.parser = propositionalLogicParser;
        this.limit = (int)Math.pow(3.0, this.nElements);
        this.answers = new int[this.limit];
        this.keys = new String[this.nElements];
        this.possibilities = new String[this.limit][this.nElements];
    }

    public void sortElements(String[] stringArray) {
        StringCompare stringCompare = new StringCompare();
        Sort sort = new Sort();
        Sort.quicksort(stringArray, 0, stringArray.length - 1, stringCompare);
    }

    public void listReversed() {
        int n;
        this.init();
        for (n = 0; n < this.nElements; ++n) {
            System.out.print(this.keys[n] + "\t");
        }
        System.out.println(this.formula);
        for (n = this.limit - 1; n >= 0; --n) {
            for (int i = 0; i < this.keys.length; ++i) {
                System.out.print(this.possibilities[n][i] + "\t");
            }
            System.out.println(this.answers[n]);
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.nElements == 0) {
            String string = "";
            StringReader stringReader = new StringReader(string);
            this.parser.ReInit(stringReader);
            try {
                int n;
                this.answers[0] = n = this.parser.AdditiveExpression();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            this.parser.ReInit(System.in);
        } else {
            this.keys = new String[this.nElements];
            Object object = this.vector;
            synchronized (object) {
                for (int i = 0; i < this.nElements; ++i) {
                    this.keys[i] = ((VariableEntry)this.vector.elementAt(i)).getKey();
                }
            }
            this.sortElements(this.keys);
            object = new ThreeValuedMatrix();
            this.possibilities = ((ThreeValuedMatrix)object).getPossibleValues(this.nElements);
            String string = "";
            for (int i = this.limit - 1; i >= 0; --i) {
                Replacer replacer = new Replacer(this.nElements);
                string = replacer.replace(this.formula, this.keys, this.possibilities[i]);
                StringReader stringReader = new StringReader(string);
                this.parser.ReInit(stringReader);
                try {
                    int n;
                    this.answers[i] = n = this.parser.AdditiveExpression();
                    continue;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            this.parser.ReInit(System.in);
        }
    }

    public boolean isSatisfiable() {
        this.init();
        for (int i = 0; i < this.answers.length; ++i) {
            if (this.answers[i] != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        this.init();
        for (int i = 0; i < this.answers.length; ++i) {
            if (this.answers[i] == 1) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
    }
}

