/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

public class LogicalSystems {
    Hashtable logical_systems_table = new Hashtable();

    public Hashtable getLogicalSystemsTable() {
        return this.logical_systems_table;
    }

    public LogicalSystems() {
        this.logical_systems_table.put("CPL", new SystemCPL());
        this.logical_systems_table.put("K3", new SystemK3());
        this.logical_systems_table.put("L3", new SystemL3());
        this.logical_systems_table.put("L", new SystemL());
        this.logical_systems_table.put("LAleph", new SystemLAleph());
        this.logical_systems_table.put("LP", new SystemLP());
        this.logical_systems_table.put("RM3", new SystemRM3());
        this.logical_systems_table.put("FDE", new SystemFDE());
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        LogicalSystems logicalSystems = new LogicalSystems();
        String string = "";
        String string2 = "";
        SystemCPL systemCPL = logicalSystems.new SystemCPL();
        System.out.println();
        System.out.println();
        System.out.println("========= CPL TEST =========");
        System.out.println("1 in English : " + systemCPL.truthValueToEnglish(new Integer(1)));
        System.out.println("0 in English : " + systemCPL.truthValueToEnglish(new Integer(0)));
        System.out.println();
        System.out.println("NOT Table ----------");
        System.out.println("~1 : " + systemCPL.interpretNot(new Integer(1)));
        System.out.println("~0 : " + systemCPL.interpretNot(new Integer(0)));
        string2 = "AND";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n9 = 1; n9 >= 0; --n9) {
            for (n8 = 1; n8 >= 0; --n8) {
                System.out.println(n9 + string + n8 + " : " + systemCPL.interpretAnd(new Integer(n9), new Integer(n8)));
            }
        }
        string2 = "OR";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n9 = 1; n9 >= 0; --n9) {
            for (n8 = 1; n8 >= 0; --n8) {
                System.out.println(n9 + string + n8 + " : " + systemCPL.interpretOr(new Integer(n9), new Integer(n8)));
            }
        }
        string2 = "IMPLIES";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n9 = 1; n9 >= 0; --n9) {
            for (n8 = 1; n8 >= 0; --n8) {
                System.out.println(n9 + string + n8 + " : " + systemCPL.interpretImplies(new Integer(n9), new Integer(n8)));
            }
        }
        string2 = "IFF";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n9 = 1; n9 >= 0; --n9) {
            for (n8 = 1; n8 >= 0; --n8) {
                System.out.println(n9 + string + n8 + " : " + systemCPL.interpretIff(new Integer(n9), new Integer(n8)));
            }
        }
        SystemK3 systemK3 = logicalSystems.new SystemK3();
        System.out.println();
        System.out.println();
        System.out.println("========= K3 TEST =========");
        System.out.println("2 in English : " + systemK3.truthValueToEnglish(new Integer(2)) + "  ( regarded as: " + systemK3.trueOrFalse(new Integer(2)) + " )");
        System.out.println("1 in English : " + systemK3.truthValueToEnglish(new Integer(1)) + "  ( regarded as: " + systemK3.trueOrFalse(new Integer(1)) + " )");
        System.out.println("0 in English : " + systemK3.truthValueToEnglish(new Integer(0)) + "  ( regarded as: " + systemK3.trueOrFalse(new Integer(0)) + " )");
        System.out.println();
        System.out.println("NOT Table ----------");
        System.out.println("~2 : " + systemK3.interpretNot(new Integer(2)));
        System.out.println("~1 : " + systemK3.interpretNot(new Integer(1)));
        System.out.println("~0 : " + systemK3.interpretNot(new Integer(0)));
        string2 = "AND";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n8 = 2; n8 >= 0; --n8) {
            for (n7 = 2; n7 >= 0; --n7) {
                System.out.println(n8 + string + n7 + " : " + systemK3.interpretAnd(new Integer(n8), new Integer(n7)));
            }
        }
        string2 = "OR";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n8 = 2; n8 >= 0; --n8) {
            for (n7 = 2; n7 >= 0; --n7) {
                System.out.println(n8 + string + n7 + " : " + systemK3.interpretOr(new Integer(n8), new Integer(n7)));
            }
        }
        string2 = "IMPLIES";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n8 = 2; n8 >= 0; --n8) {
            for (n7 = 2; n7 >= 0; --n7) {
                System.out.println(n8 + string + n7 + " : " + systemK3.interpretImplies(new Integer(n8), new Integer(n7)));
            }
        }
        string2 = "IFF";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n8 = 2; n8 >= 0; --n8) {
            for (n7 = 2; n7 >= 0; --n7) {
                System.out.println(n8 + string + n7 + " : " + systemK3.interpretIff(new Integer(n8), new Integer(n7)));
            }
        }
        SystemL3 systemL3 = logicalSystems.new SystemL3();
        System.out.println();
        System.out.println();
        System.out.println("========= L3 TEST =========");
        System.out.println("2 in English : " + systemL3.truthValueToEnglish(new Integer(2)) + "  ( regarded as: " + systemL3.trueOrFalse(new Integer(2)) + " )");
        System.out.println("1 in English : " + systemL3.truthValueToEnglish(new Integer(1)) + "  ( regarded as: " + systemL3.trueOrFalse(new Integer(1)) + " )");
        System.out.println("0 in English : " + systemL3.truthValueToEnglish(new Integer(0)) + "  ( regarded as: " + systemL3.trueOrFalse(new Integer(0)) + " )");
        System.out.println();
        System.out.println("NOT Table ----------");
        System.out.println("~2 : " + systemL3.interpretNot(new Integer(2)));
        System.out.println("~1 : " + systemL3.interpretNot(new Integer(1)));
        System.out.println("~0 : " + systemL3.interpretNot(new Integer(0)));
        string2 = "AND";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n7 = 2; n7 >= 0; --n7) {
            for (n6 = 2; n6 >= 0; --n6) {
                System.out.println(n7 + string + n6 + " : " + systemL3.interpretAnd(new Integer(n7), new Integer(n6)));
            }
        }
        string2 = "OR";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n7 = 2; n7 >= 0; --n7) {
            for (n6 = 2; n6 >= 0; --n6) {
                System.out.println(n7 + string + n6 + " : " + systemL3.interpretOr(new Integer(n7), new Integer(n6)));
            }
        }
        string2 = "IMPLIES";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n7 = 2; n7 >= 0; --n7) {
            for (n6 = 2; n6 >= 0; --n6) {
                System.out.println(n7 + string + n6 + " : " + systemL3.interpretImplies(new Integer(n7), new Integer(n6)));
            }
        }
        string2 = "IFF";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n7 = 2; n7 >= 0; --n7) {
            for (n6 = 2; n6 >= 0; --n6) {
                System.out.println(n7 + string + n6 + " : " + systemL3.interpretIff(new Integer(n7), new Integer(n6)));
            }
        }
        SystemLP systemLP = logicalSystems.new SystemLP();
        System.out.println();
        System.out.println();
        System.out.println("========= LP TEST =========");
        System.out.println("2 in English : " + systemLP.truthValueToEnglish(new Integer(2)) + "  ( regarded as: " + systemLP.trueOrFalse(new Integer(2)) + " )");
        System.out.println("1 in English : " + systemLP.truthValueToEnglish(new Integer(1)) + "  ( regarded as: " + systemLP.trueOrFalse(new Integer(1)) + " )");
        System.out.println("0 in English : " + systemLP.truthValueToEnglish(new Integer(0)) + "  ( regarded as: " + systemLP.trueOrFalse(new Integer(0)) + " )");
        System.out.println();
        System.out.println("NOT Table ----------");
        System.out.println("~2 : " + systemLP.interpretNot(new Integer(2)));
        System.out.println("~1 : " + systemLP.interpretNot(new Integer(1)));
        System.out.println("~0 : " + systemLP.interpretNot(new Integer(0)));
        string2 = "AND";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n6 = 2; n6 >= 0; --n6) {
            for (n5 = 2; n5 >= 0; --n5) {
                System.out.println(n6 + string + n5 + " : " + systemLP.interpretAnd(new Integer(n6), new Integer(n5)));
            }
        }
        string2 = "OR";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n6 = 2; n6 >= 0; --n6) {
            for (n5 = 2; n5 >= 0; --n5) {
                System.out.println(n6 + string + n5 + " : " + systemLP.interpretOr(new Integer(n6), new Integer(n5)));
            }
        }
        string2 = "IMPLIES";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n6 = 2; n6 >= 0; --n6) {
            for (n5 = 2; n5 >= 0; --n5) {
                System.out.println(n6 + string + n5 + " : " + systemLP.interpretImplies(new Integer(n6), new Integer(n5)));
            }
        }
        string2 = "IFF";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n6 = 2; n6 >= 0; --n6) {
            for (n5 = 2; n5 >= 0; --n5) {
                System.out.println(n6 + string + n5 + " : " + systemLP.interpretIff(new Integer(n6), new Integer(n5)));
            }
        }
        SystemRM3 systemRM3 = logicalSystems.new SystemRM3();
        System.out.println();
        System.out.println();
        System.out.println("========= RM3 TEST =========");
        System.out.println("2 in English : " + systemRM3.truthValueToEnglish(new Integer(2)) + "  ( regarded as: " + systemRM3.trueOrFalse(new Integer(2)) + " )");
        System.out.println("1 in English : " + systemRM3.truthValueToEnglish(new Integer(1)) + "  ( regarded as: " + systemRM3.trueOrFalse(new Integer(1)) + " )");
        System.out.println("0 in English : " + systemRM3.truthValueToEnglish(new Integer(0)) + "  ( regarded as: " + systemRM3.trueOrFalse(new Integer(0)) + " )");
        System.out.println();
        System.out.println("NOT Table ----------");
        System.out.println("~2 : " + systemRM3.interpretNot(new Integer(2)));
        System.out.println("~1 : " + systemRM3.interpretNot(new Integer(1)));
        System.out.println("~0 : " + systemRM3.interpretNot(new Integer(0)));
        string2 = "AND";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n5 = 2; n5 >= 0; --n5) {
            for (n4 = 2; n4 >= 0; --n4) {
                System.out.println(n5 + string + n4 + " : " + systemRM3.interpretAnd(new Integer(n5), new Integer(n4)));
            }
        }
        string2 = "OR";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n5 = 2; n5 >= 0; --n5) {
            for (n4 = 2; n4 >= 0; --n4) {
                System.out.println(n5 + string + n4 + " : " + systemRM3.interpretOr(new Integer(n5), new Integer(n4)));
            }
        }
        string2 = "IMPLIES";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n5 = 2; n5 >= 0; --n5) {
            for (n4 = 2; n4 >= 0; --n4) {
                System.out.println(n5 + string + n4 + " : " + systemRM3.interpretImplies(new Integer(n5), new Integer(n4)));
            }
        }
        string2 = "IFF";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n5 = 2; n5 >= 0; --n5) {
            for (n4 = 2; n4 >= 0; --n4) {
                System.out.println(n5 + string + n4 + " : " + systemRM3.interpretIff(new Integer(n5), new Integer(n4)));
            }
        }
        double d = 0.5;
        double[] dArray = new double[]{1.0, 0.75, 0.5, 0.25, 0.0};
        LogicalSystems logicalSystems2 = logicalSystems;
        logicalSystems2.getClass();
        SystemL systemL = logicalSystems2.new SystemL(d);
        System.out.println();
        System.out.println();
        System.out.println("========= L TEST =========");
        System.out.println("The boarder line lambda value is : " + d);
        for (n3 = 0; n3 < dArray.length; ++n3) {
            System.out.println(dArray[n3] + " in English : " + systemL.truthValueToEnglish(new Double(dArray[n3])) + "  ( regarded as: " + systemL.trueOrFalse(new Double(dArray[n3])) + " )");
        }
        System.out.println(systemL.interpretNot(new Double(1.5)));
        System.out.println();
        System.out.println("NOT Table ----------");
        for (n3 = 0; n3 < dArray.length; ++n3) {
            System.out.println("~" + dArray[n3] + "   :   " + systemL.interpretNot(new Double(dArray[n3])));
        }
        string2 = "AND";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n3 = 0; n3 < dArray.length; ++n3) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                System.out.println(dArray[n3] + "   " + dArray[n2] + "   :   " + systemL.interpretAnd(new Double(dArray[n3]), new Double(dArray[n2])));
            }
        }
        string2 = "OR";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n3 = 0; n3 < dArray.length; ++n3) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                System.out.println(dArray[n3] + "   " + dArray[n2] + "   :   " + systemL.interpretOr(new Double(dArray[n3]), new Double(dArray[n2])));
            }
        }
        string2 = "IMPLIES";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n3 = 0; n3 < dArray.length; ++n3) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                System.out.println(dArray[n3] + "   " + dArray[n2] + "   :   " + systemL.interpretImplies(new Double(dArray[n3]), new Double(dArray[n2])));
            }
        }
        string2 = "IFF";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n3 = 0; n3 < dArray.length; ++n3) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                System.out.println(dArray[n3] + "   " + dArray[n2] + "   :   " + systemL.interpretIff(new Double(dArray[n3]), new Double(dArray[n2])));
            }
        }
        SystemLAleph systemLAleph = logicalSystems.new SystemLAleph();
        System.out.println();
        System.out.println();
        System.out.println("========= LALEPH TEST =========");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            System.out.println(dArray[n2] + " in English : " + systemLAleph.truthValueToEnglish(new Double(dArray[n2])) + "  ( regarded as: " + systemLAleph.trueOrFalse(new Double(dArray[n2])) + " )");
        }
        System.out.println();
        System.out.println("NOT Table ----------");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            System.out.println("~" + dArray[n2] + "   :   " + systemLAleph.interpretNot(new Double(dArray[n2])));
        }
        string2 = "AND";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray.length; ++n) {
                System.out.println(dArray[n2] + "   " + dArray[n] + "   :   " + systemLAleph.interpretAnd(new Double(dArray[n2]), new Double(dArray[n])));
            }
        }
        string2 = "OR";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray.length; ++n) {
                System.out.println(dArray[n2] + "   " + dArray[n] + "   :   " + systemLAleph.interpretOr(new Double(dArray[n2]), new Double(dArray[n])));
            }
        }
        string2 = "IMPLIES";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray.length; ++n) {
                System.out.println(dArray[n2] + "   " + dArray[n] + "   :   " + systemLAleph.interpretImplies(new Double(dArray[n2]), new Double(dArray[n])));
            }
        }
        string2 = "IFF";
        System.out.println();
        System.out.println(string2 + " Table ----------");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray.length; ++n) {
                System.out.println(dArray[n2] + "   " + dArray[n] + "   :   " + systemLAleph.interpretIff(new Double(dArray[n2]), new Double(dArray[n])));
            }
        }
        BinaryTwoValuedRelation binaryTwoValuedRelation = new BinaryTwoValuedRelation();
        binaryTwoValuedRelation.add("a", "1");
        binaryTwoValuedRelation.add("b", "1");
        binaryTwoValuedRelation.add("b", "0");
        binaryTwoValuedRelation.add("d", "0");
        LogicalSystems logicalSystems3 = logicalSystems;
        logicalSystems3.getClass();
        SystemFDE systemFDE = logicalSystems3.new SystemFDE(binaryTwoValuedRelation);
        System.out.println();
        System.out.println();
        System.out.println("========= FDE TEST =========");
        System.out.println("3 in English : " + systemFDE.truthValueToEnglish(new Integer(3)) + "  ( regarded as: " + systemFDE.trueOrFalse(new Integer(3)) + " )");
        System.out.println("2 in English : " + systemFDE.truthValueToEnglish(new Integer(2)) + "  ( regarded as: " + systemFDE.trueOrFalse(new Integer(2)) + " )");
        System.out.println("1 in English : " + systemFDE.truthValueToEnglish(new Integer(1)) + "  ( regarded as: " + systemFDE.trueOrFalse(new Integer(1)) + " )");
        System.out.println("0 in English : " + systemFDE.truthValueToEnglish(new Integer(0)) + "  ( regarded as: " + systemFDE.trueOrFalse(new Integer(0)) + " )");
        System.out.println();
        System.out.println("NOT Table:");
        System.out.print(systemFDE.interpretNot(systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretNot(systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretNot(systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretNot(systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.println();
        System.out.println("AND Table:");
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretAnd(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.println();
        System.out.println("OR Table:");
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretOr(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.println();
        System.out.println("IMPLIES Table:");
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretImplies(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.println();
        System.out.println("IFF Table:");
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("a"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("b"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("c"), systemFDE.interpretSymbol("d")));
        System.out.println();
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("a")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("b")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("c")));
        System.out.print(systemFDE.interpretIff(systemFDE.interpretSymbol("d"), systemFDE.interpretSymbol("d")));
        System.out.println();
    }

    public class SystemFDE
    implements LogicalSystem {
        private final int b = 2;
        private final int n = 3;
        private BinaryTwoValuedRelation R;
        int[] D = new int[]{1, 2};
        final String system_name = "FDE";

        public boolean truthTableConstructable() {
            return true;
        }

        public String getSystemName() {
            return "FDE";
        }

        public SystemFDE(BinaryTwoValuedRelation binaryTwoValuedRelation) {
            this.R = binaryTwoValuedRelation;
        }

        public SystemFDE() {
            this.R = new BinaryTwoValuedRelation();
        }

        public void setRelation(BinaryTwoValuedRelation binaryTwoValuedRelation) {
            this.R = binaryTwoValuedRelation;
        }

        public int getNTruthValues() {
            return 4;
        }

        public boolean trueOrFalse(Object object) {
            int n = (Integer)object;
            for (int i = 0; i < this.D.length; ++i) {
                if (n != this.D[i]) continue;
                return true;
            }
            return false;
        }

        public String truthValueToEnglish(Object object) {
            int n = (Integer)object;
            if (n == 0) {
                return "0 ; False and not True";
            }
            if (n == 1) {
                return "1 ; True and not False";
            }
            if (n == 2) {
                return "2 ; Both True and False";
            }
            if (n == 3) {
                return "3 ; Neither True nor False";
            }
            return "Invalid, unrecognized value (Value should be either 0, 1, 2, or 3.)";
        }

        public Object interpretSymbol(Object object) {
            String string = object.toString();
            if (this.R.contains(string, "1") && this.R.contains(string, "0")) {
                return new Integer(2);
            }
            if (!this.R.contains(string, "1") && !this.R.contains(string, "0")) {
                return new Integer(3);
            }
            if (this.R.contains(string, "1")) {
                return new Integer("1");
            }
            return new Integer("0");
        }

        public Object interpretNot(Object object) {
            int n = (Integer)object;
            if (n == 1) {
                return new Integer(0);
            }
            if (n == 0) {
                return new Integer(1);
            }
            return new Integer(n);
        }

        public Object interpretAnd(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n2 == 1) {
                return new Integer(n);
            }
            if (n2 == 0) {
                return new Integer(0);
            }
            if ((n == 1 || n == 2) && n2 == 2) {
                return new Integer(2);
            }
            if ((n == 1 || n == 3) && n2 == 3) {
                return new Integer(3);
            }
            return new Integer(0);
        }

        public Object interpretOr(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n == 1 || n2 == 1) {
                return new Integer(1);
            }
            if (n == 0 && n2 == 0) {
                return new Integer(0);
            }
            if (!(n != 0 && n != 3 || n2 != 0 && n2 != 3)) {
                return new Integer(3);
            }
            if (n == 3 && n2 == 2 || n == 2 && n2 == 3) {
                return new Integer(1);
            }
            return new Integer(2);
        }

        public Object interpretImplies(Object object, Object object2) {
            return this.interpretOr(this.interpretNot(object), object2);
        }

        public Object interpretIff(Object object, Object object2) {
            return this.interpretAnd(this.interpretImplies(object, object2), this.interpretImplies(object2, object));
        }

        public Object getCorrespondingNumberFormat(String string) {
            Double d = new Double(string);
            int n = d.intValue();
            return new Integer(n);
        }

        public Object getTrueValue() {
            return new Integer(1);
        }

        public Object getFalseValue() {
            return new Integer(0);
        }
    }

    public class SystemLAleph
    extends SystemL
    implements LogicalSystem {
        final String system_name = "LAleph";

        public String getSystemName() {
            return "LAleph";
        }

        public boolean trueOrFalse(Object object) {
            double d = (Double)object;
            return d == 1.0;
        }

        public String truthValueToEnglish(Object object) {
            double d = (Double)object;
            if (d == this.completely_true) {
                return "1.0 ; Completely True";
            }
            if (d == this.completely_false) {
                return "0.0 ; Completely False";
            }
            return "1.0 > answer > 0.0 ; False";
        }
    }

    public class SystemL
    implements LogicalSystem {
        private double border_line_lambda = 0.5;
        double completely_false = 0.0;
        double completely_true = 1.0;
        final String system_name = "L";

        public void setBorderLine(double d) {
            this.border_line_lambda = d;
        }

        public boolean truthTableConstructable() {
            return false;
        }

        public String getSystemName() {
            return "L";
        }

        public SystemL() {
        }

        public SystemL(double d) {
            this.border_line_lambda = d;
        }

        public SystemL(Object object) {
            double d;
            this.border_line_lambda = d = ((Double)object).doubleValue();
        }

        public int getNTruthValues() {
            return -1;
        }

        public boolean trueOrFalse(Object object) {
            double d = (Double)object;
            return d >= this.border_line_lambda;
        }

        public String truthValueToEnglish(Object object) {
            double d = (Double)object;
            if (d == this.completely_true) {
                return "1.0 ; Completely True";
            }
            if (d >= this.border_line_lambda) {
                return "1.0 > value >= " + this.border_line_lambda + " ; True";
            }
            if (d == this.completely_false) {
                return "0.0 ; Completely False";
            }
            return this.border_line_lambda + " > value > 0.0 ; False";
        }

        public Object interpretNot(Object object) {
            double d = (Double)object;
            if (d >= 0.0 && d <= 1.0) {
                return new Double(1.0 - d);
            }
            System.out.println("WARNING: Value taken by a sentence symbol within this system must be a real number between 0 and 1.0, inclusive (i.e., [0.0, 1.0]).  ");
            System.out.println("Returning 0.0 instead...");
            return new Double(0.0);
        }

        public Object interpretAnd(Object object, Object object2) {
            double d = (Double)object;
            double d2 = (Double)object2;
            return new Double(Math.min(d, d2));
        }

        public Object interpretOr(Object object, Object object2) {
            double d = (Double)object;
            double d2 = (Double)object2;
            return new Double(Math.max(d, d2));
        }

        public Object interpretImplies(Object object, Object object2) {
            double d = (Double)object;
            double d2 = (Double)object2;
            if (d >= 0.0 && d <= 1.0 && d2 >= 0.0 && d2 <= 1.0) {
                if (d <= d2) {
                    return new Double(1.0);
                }
                return new Double(1.0 - (d - d2));
            }
            System.out.println("WARNING: Value taken by a sentence symbol within this system must be a real number between 0 and 1.0, inclusive (i.e., [0.0, 1.0]).  ");
            System.out.println("Returning 0.0 instead...");
            return new Double(0.0);
        }

        public Object interpretIff(Object object, Object object2) {
            return this.interpretAnd(this.interpretImplies(object, object2), this.interpretImplies(object2, object));
        }

        public Object getCorrespondingNumberFormat(String string) {
            Double d = new Double(string);
            return d;
        }

        public Object getTrueValue() {
            return new Double(1.0);
        }

        public Object getFalseValue() {
            return new Double(0.0);
        }
    }

    public class SystemRM3
    extends SystemLP
    implements LogicalSystem {
        final String system_name = "RM3";

        public String getSystemName() {
            return "RM3";
        }

        public Object interpretImplies(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n == 0 || n2 == 1) {
                return new Integer(1);
            }
            if (n == 2 && n2 == 2) {
                return new Integer(2);
            }
            return new Integer(0);
        }
    }

    public class SystemLP
    extends SystemK3
    implements LogicalSystem {
        int[] D = new int[]{1, 2};
        final String system_name = "LP";

        public String getSystemName() {
            return "LP";
        }

        public boolean trueOrFalse(Object object) {
            int n = (Integer)object;
            for (int i = 0; i < this.D.length; ++i) {
                if (n != this.D[i]) continue;
                return true;
            }
            return false;
        }

        public String truthValueToEnglish(Object object) {
            int n = (Integer)object;
            if (n == 0) {
                return "0 ; False and false only";
            }
            if (n == 1) {
                return "1 ; True and true only";
            }
            return "2 ; Both true and false";
        }
    }

    public class SystemL3
    extends SystemK3
    implements LogicalSystem {
        final String system_name = "L3";

        public String getSystemName() {
            return "L3";
        }

        public Object interpretImplies(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n == 0 || n2 == 1) {
                return new Integer(1);
            }
            if (n == 1 && n2 == 0) {
                return new Integer(0);
            }
            if (n == 2 && n2 == 2) {
                return new Integer(1);
            }
            return new Integer(2);
        }
    }

    public class SystemK3
    implements LogicalSystem {
        int[] D = new int[]{1};
        final String system_name = "K3";

        public boolean truthTableConstructable() {
            return true;
        }

        public String getSystemName() {
            return "K3";
        }

        public int getNTruthValues() {
            return 3;
        }

        public boolean trueOrFalse(Object object) {
            int n = (Integer)object;
            for (int i = 0; i < this.D.length; ++i) {
                if (n != this.D[i]) continue;
                return true;
            }
            return false;
        }

        public String truthValueToEnglish(Object object) {
            int n = (Integer)object;
            if (n == 0) {
                return "0 ; False";
            }
            if (n == 1) {
                return "1 ; True";
            }
            return "2 ; Unknown";
        }

        public Object interpretNot(Object object) {
            int n = (Integer)object;
            if (n == 1) {
                return new Integer(0);
            }
            if (n == 0) {
                return new Integer(1);
            }
            return new Integer(2);
        }

        public Object interpretAnd(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n == 1 && n2 == 1) {
                return new Integer(1);
            }
            if (n == 0 || n2 == 0) {
                return new Integer(0);
            }
            return new Integer(2);
        }

        public Object interpretOr(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n == 1 || n2 == 1) {
                return new Integer(1);
            }
            if (n == 0 && n2 == 0) {
                return new Integer(0);
            }
            return new Integer(2);
        }

        public Object interpretImplies(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n == 0 || n2 == 1) {
                return new Integer(1);
            }
            if (n == 1 && n2 == 0) {
                return new Integer(0);
            }
            return new Integer(2);
        }

        public Object interpretIff(Object object, Object object2) {
            return this.interpretAnd(this.interpretImplies(object, object2), this.interpretImplies(object2, object));
        }

        public Object getCorrespondingNumberFormat(String string) {
            Double d = new Double(string);
            int n = d.intValue();
            return new Integer(n);
        }

        public Object getTrueValue() {
            return new Integer(1);
        }

        public Object getFalseValue() {
            return new Integer(0);
        }
    }

    public class SystemCPL
    implements LogicalSystem {
        final String system_name = "CPL";
        int[] D = new int[]{1};

        public boolean truthTableConstructable() {
            return true;
        }

        public int getNTruthValues() {
            return 2;
        }

        public String getSystemName() {
            return "CPL";
        }

        public boolean trueOrFalse(Object object) {
            int n = (Integer)object;
            for (int i = 0; i < this.D.length; ++i) {
                if (n != this.D[i]) continue;
                return true;
            }
            return false;
        }

        public String truthValueToEnglish(Object object) {
            int n = (Integer)object;
            if (n == 0) {
                return "0 ; False";
            }
            return "1 ; True";
        }

        public Object interpretNot(Object object) {
            int n = (Integer)object;
            if (n == 0) {
                return new Integer(1);
            }
            return new Integer(0);
        }

        public Object interpretAnd(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n != 0 && n2 != 0) {
                return new Integer(1);
            }
            return new Integer(0);
        }

        public Object interpretOr(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n == 0 && n2 == 0) {
                return new Integer(0);
            }
            return new Integer(1);
        }

        public Object interpretImplies(Object object, Object object2) {
            int n = (Integer)object;
            int n2 = (Integer)object2;
            if (n != 0 && n2 == 0) {
                return new Integer(0);
            }
            return new Integer(1);
        }

        public Object interpretIff(Object object, Object object2) {
            return this.interpretAnd(this.interpretImplies(object, object2), this.interpretImplies(object2, object));
        }

        public Object getCorrespondingNumberFormat(String string) {
            Double d = new Double(string);
            int n = d.intValue();
            return new Integer(n);
        }

        public Object getTrueValue() {
            return new Integer(1);
        }

        public Object getFalseValue() {
            return new Integer(0);
        }
    }
}

