<?php
//Korean (UTF-8)

//the above line is needed so that pivot knows how to display it in the user info.
//it also needs to be on the 2nd line.

// Korean translation of Pivot lang file
// Created by Hwang Joonhyung (envia@envia.pe.kr)
// http://www.envia.pe.kr

// allow for different encoding for non-western languages
$encoding="utf-8";
$langname="ko";

//		General		\\
$lang['general'] = array (
	'yes' => '예',	//affirmative
	'no' => '아니오',	//negative
	'go' => '계속',	//proceed

	'minlevel' => '피벗의 이 영역에 접근할 권한이 없습니다.',
	'email' => '이메일',
	'url' => 'URL',
	'further_options' => "다른 선택 사항",
	'basic_view' => "간단히 보기",
	'basic_view_desc' => "가장 자주 쓰이는 항목만 봅니다",
	'extended_view' => "자세히 보기",
	'extended_view_desc' => "편집할 수 있는 모든 항목을 봅니다",
	'select' => "선택",
	'cancel' => "취소",
	'delete' => '삭제',
	'welcome' => "%build%에 오신 것을 환영합니다.",
	'write' => "쓰기",
	'write_open_error' => "쓰기 에러. 파일을 쓸 수 있게 열 수 없음",
	'write_write_error' => "쓰기 에러. 파일에 쓸 수 없음",
	'done' => "완료",
	'shortcuts' => "바로가기",
	'cantdelete' => "%title%의 삭제를 할 수 있도록 허가되지 않았습니다!",
	'cantdothat' => "%title%에 그것을 하도록 허가되지 않았습니다!",
);


$lang['userlevels'] = array (
//		'Superadmin', 'Administrator', 'Advanced', 'Normal', 'Moblogger'
		'절대자', '관리자', '전문가', '사용자', '모블로거'
		//  this one might be a bit hard to translate, but basically it's an order of
		//  power or trust.  Superadmin would be the person in charge - no one can do
		//  anything about his decisions. Admin is only regulated by the Superadmin, 
		//  Advanced by the Admin and Superadmin, etc..
		//  Just get the idea of it.
);


$lang['numbers'] = array (
	'영', '한', '두', '세', '네', '다섯', '여섯', '일곱', '여덟', '아홉', '열', '열한', '열두', '열세', '열네', '열다섯', '열여섯'
);


$lang['months'] = array (
	'1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월'
);


$lang['months_abbr'] = array (
//	'1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월'
	'1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'
);


$lang['days'] = array (
	'일요일', '월요일', '화요일', '수요일', '목요일', '금요일', '토요일'
);


$lang['days_abbr'] = array (
	'일', '월', '화', '수', '목', '금', '토'
);


$lang['datetime_words'] = array (
	'년', '월', '주', '일', '시', '분', '초'	//the actual words for them.
);


//		Login Page		\\
$lang['login'] = array (
	'title' => '로그인',
	'name' => '사용자 이름',
	'pass' => '비밀번호',
	'remember' => '기억할 것',
	'rchoice' => array (
		'0' => '없음',
		'1' => '사용자 이름과 비밀번호',
		'2' => '로그인 상태'
	),
	'delete_cookies_desc' => '정확한 사용자 이름과 비밀번호를 입력했는데도 로그인을 하지 못한 것이 확실하다면,<br />쿠키를 지워 볼 수 있습니다.',
	'delete_cookies' => '쿠키 지우기',
	'retry' => '사용자 이름이나 비밀번호가 잘못되었습니다.',
	'banned' => '10번이나 로그인에 실패했기 때문에, 12시간 동안 IP가 차단됩니다.',
);


//		Main Bar		\\
	$lang['userbar'] = array (
	'main' => '개관',
	'entries' => '글',
	'submit' => '새 글 쓰기',
	'comments' => '덧글',
	'modify' => '글 고치기',
	'userinfo' => '내 정보',
	'u_settings' => '내 설정',
	'u_marklet' => '빠른 도구',
	'files' => '매체 관리',
	'upload' => '올리기',
	'stats' => '통계',
	'admin' => '관리',

	'main_title' => '간추린 피벗',
	'entries_title' => '간추린 글 관리',
	'submit_title' => '새 글을 씁니다',
	'comments_title' => '덧글을 고치거나 지웁니다',
	'modify_title' => '글을 고칩니다',
	'userinfo_title' => '내 정보를 봅니다',
	'u_settings_title' => '내 설정을 고칩니다',
	'u_marklet_title' => '빠른 도구를 만듭니다',
	'files_title' => '매체를 올리고 관리합니다',
	'upload_title' => '파일을 올립니다',
	'uploaded_success' => '파일이 올려졌습니다',
	'stats_title' => '로그와 통계를 봅니다',
	'updatetitles_title' => '로그와 통계를 봅니다',
	'admin_title' => '간추린 관리',
	'recent_entries' => '최근 글',
	'recent_comments' => '최근 덧글',
);


$lang['adminbar'] = array (
	//		Admin Bar		\\
	//'trebuild' => 'Rebuild all Files', rolled into maintenance

	'seeusers' => '사용자',
	'seeconfig' => '설정',
	'filemappings' => '파일 지도',
	'templates' => '서식',
	'maintenance' => '유지보수',
	'regen' => '모든 파일 다시 만들기',
	'blogs' => '웹로그',
	'categories' => '갈래',
	'verifydb' => '데이터베이스 검증하기',
	'buildindex' => '색인 다시 만들기',
	'buildsearchindex' => '검색 색인 다시 만들기',
	'buildfrontpage' => '대문 다시 만들기',
	'sendping' => '핑 보내기',


	'backup' => '백업',
	'description' => '설명',
	'conversion' => '변환',
	'seeusers_title' => '사용자를 만들고, 고치고, 지우기',
	'userfields' => '사용자 정보 항목',
	'userfields_title' => '사용자 정보 항목을 만들고, 고치고, 지웁니다',
	'seeconfig_title' => '설정 파일 고치기',
	'filemappings_title' => '피벗의 어느 파일이 어느 웹로그에 의해 만들어져 쓰이고 있는지 봅니다',
	'templates_title' => '서식을 만들고, 고치고, 지우기',
	'maintenance_title' => '피벗의 일상적인 유지 보수를 합니다',
	'regen_title' => '피벗이 만든 파일과 보관소를 다시 만듭니다',
	'blogs_title' => '웹로그를 만들고, 고치고 지웁니다',
	'blogs_edit_title' => '이 웹로그의 설정을 고칩니다: ',
	'categories_title' => '갈래를 만들고, 고치고, 지웁니다',
	'verifydb_title' => '데이터베이스의 무결성을 검증합니다',
	'buildindex_title' => '데이터베이스의 색인을 다시 만듭니다',
	'buildsearchindex_title' => '글을 검색할 수 있도록 검색 색인을 다시 만듭니다',
	'buildfrontpage_title' => '웹로그 각각의 대문과 최근 보관소와 RSS파일을 새로 만듭니다.',
	'backup_title' => '글의 백업을 만듭니다',
	'ipblocks' => 'IP 차단',
	'ipblocks_title' => '차단된 IP 주소를 보고 고칩니다',
	'ipblocks_stored' => 'IP 주소들이 저장되었습니다.',
	'ipblocks_store' => '이 IP 주소들을 저장',
	'fileexplore' => '파일 탐색기',
	'fileexplore_title' => '텍스트와 데이터베이스 파일을 봅니다',
	'sendping_title' => '트랙백을 갱신하도록 하기 위해 핑을 보냅니다.',
	'buildindex_start' => '색인을 만듭니다. 시간이 조금 걸리니, 방해하지 말아 주시기 바랍니다.',
	'buildsearchindex_start' => '검색 색인을 만듭니다. 시간이 조금 걸리니, 방해하지 말아 주시기 바랍니다.',
	'buildindex_finished' => '완료! 색인 생성에는 %num%초가 걸렸습니다.',

	'filemappings_desc' => '여러분은 아래에서 피벗에 있는 웹로그들의 개관과, 그들이 무슨 서식으로 어떤 파일들을 만들었는지 볼 수 있습니다. 파일이 만들어질 때 문제가 있다면 해결하는 데 도움이 될 것입니다.',
);


$lang['templates'] = array (
	'rollback' => '되돌리기',
	'create_template' => '서식 만들기',
	'create_template_info' => '피벗 서식을 직접 만듭니다',
	'no_comment' => '덧말 없음',
	'comment' => '덧말*',
	'comment_note' => '(*참고: <b>첫</b> 저장에만 덧말을 달 수 있습니다)',
	'create' => '서식 만들기',
	'editing' => '고치기',
	'filename' => '파일 이름',
	'save_changes' => '변경 사항 저장',
	'save_template' => '서식 저장',
);


//		Admin			\\
// bob notes: Mark made these, i think they should be replaced by the 'adminbar']['xxx_title'] ones
$lang['admin'] = array (
	'seeusers' => '사용자를 만들고, 고치고, 지웁니다',
	'seeconfig' => '설정 파일을 고칩니다',
	'templates' => '서식을 만들고, 고치고, 지웁니다',
	'maintenance' => '\'파일 다시 만들기\', \'데이터 베이스 검증하기\', \'색인 다시 만들기\', \'백업\'과 같은 일상적인 피벗 파일들의 유지 보수를 수행합니다',
	'regen' => '피벗이 만든 모든 쪽을 다시 만듭니다',
	'blogs' => '피벗이 게시할 웹로그를 만들고, 고치고, 지웁니다',
);


//		Maintenace		\\
$lang['maint'] = array (
	'title' => '유지 보수',
	'gen_arc_title' => '보관소 만들기', /* bob notes: redundant, see 'regen' */
	'gen_arc_text' => '보관소를 완전히 새로 만듭니다', /* bob notes: redundant, see 'regen' */
	'xml_title' => '데이터베이스 검증', /* bob notes: replace with more general 'Verify DB' */
	'xml_text' => '데이터베이스의 무결성을 검증합니다 (필요할 경우 고칩니다)', /* bob notes: replace with more general 'Verify DB' */
	'backup_title' => '백업',
	'backup_text' => '피벗의 필수 파일들의 백업을 만듭니다',
);


//		Stats and referers		\\
$lang['stats'] = array (
	'show_last' => "최근",
	'20ref' => "20 방문 경로",
	'50ref' => "50 방문 경로",
	'allref' => "모든 방문 경로",
	'updateref' => "방문 경로와 제목과의 관계를 갱신",
	'hostaddress' => '호스트 주소 (IP 주소)',
	'whichpage' => '접근한 페이지',

	'getting' => '새 제목 얻어오기',
	'awhile' => '시간이 조금 걸리니, 방해하지 말아 주시기 바랍니다.',
	'firstpass' => '일단계',
	'secondpass' => '이단계',
	'nowuptodate' => '방문 경로와 제목과의 관계가 갱신되었습니다.',
	'finished' => '완료',
);


//		User Info		\\
	$lang['userinfo'] = array (
	'editfields' => '사용자 항목 편집',
	'desc_editfields' => '사용자가 자신을 설명할 수 있는 항목을 고칩니다',
	'username' => '사용자 이름',
	'pass1' => '비밀번호',
	'pass2' => '비밀번호 (확인)',
	'email' => '이메일',
	'userlevel' => '사용자 수준',
	'userlevel_desc' => '사용자 수준에 따라 할 수 있는 일이 결정됩니다.',
	'language' => '언어',
	'edituser' => '사용자 고치기',  //the link to.. well, edit the user (also the title)
	'edituserinfo' => '사용자 정보 고치기',
	'newuser' => '새 사용자 만들기',
	'desc_newuser' => '피벗의 새 계정을 만들어서 웹로그에 글을 쓸 수 있게 합니다',
	'newuser_button' => '만들기',
	'edituser_button' => '바꾸기',
	'pass_too_short' => '비밀번호의 길이는 적어도 4자가 되어야 합니다.',
	'pass_dont_match' => '비밀번호가 서로 맞지 않습니다.',
	'username_in_use' => '사용자 이름이 이미 쓰이고 있습니다.',
	'username_too_short' => '사용자 이름은 4자이거나 더 길어야 합니다.',
	'username_not_valid' => '사용자 이름은 알파벳(A~Z)과 숫자(0~9)와 및줄(_)로만 이루어져야 합니다.',
	'not_good_email' => '유효한 이메일 주소가 아닙니다.',
	'c_admin_title' => '관리자 만들기 확인',
	'c_admin_message' => $lang['userlevels']['1'].'는 피벗의 모든 곳에 접근하고, 모든 소식과 모든 덧글을 고칠 수 있으며, 모든 설정을 바꿀 수 있습니다. %s '.$lang['userlevels']['1'].'를 만드시겠습니까?',
);


//		Config Page		\\
	$lang['config'] = array (
	'save' => '설정 저장',

	'sitename' => '사이트 이름',
	'defaultlanguage' => '기본 언어',
	'siteurl' => '사이트 URL',
	'header_fileinfo' => '파일 정보',
	'localpath' => '지역 경로',
	'debug_options' => '디버그 옵션',
	'debug' => '디버그 모드',
	'debug_desc' => '임의로 여기저기에서 디버그 정보를 보여줍니다',
	'log' => '로그파일',
	'log_desc' => '다양한 활동들의 로그파일을 유지합니다',

	'unlink' => '파일 언링크',
	'unlink_desc' => '무시무시한 safe_mode가 켜져 있는 몇몇 서버에서는 이 선택 사항을 고를 필요가 있습니다. 대부분의 서버에서는 이 선택 사항이 영향을 미치지 않을 것입니다.',
	'header_uploads' => '파일 올리기', /* envia notes: we need this! */
	'chmod' => '파일 권한 바꾸기',
	'chmod_desc' => '몇몇 서버에서는 만들어진 파일의 권한을 특별한 방법으로 바꾸어주어야 할 때가 있습니다. \'0644\'와 \'0755\'가 널리 쓰입니다. 여러분이 무엇을 하는지 알지 못한다면 이 값을 바꾸지 마십시오.',
	'upload_path' => '파일 올리기 경로',
	'upload_accept' => '받아들이는 유형',
	'upload_extension' => '기본 확장자',
	'upload_save_mode' => '덮어쓰기',
	'make_safe' => '깨끗한 파일 이름',
	'c_upload_save_mode' => '파일 이름을 늘입니다',
	'max_filesize' => '최대 파일 크기',
	'header_datetime' => '날짜/시간 (오프셋만큼 시간을 밉니다.)',
	'timeoffset_unit' => '시간 오프셋 단위',
	'timeoffset' => '시간 오프셋',
	'header_extra' => '기타 설정',
	'wysiwyg' => 'WYSIWYG 편집기 사용',
	'wysiwyg_desc' => 'WYSIWYG 편집기를 기본으로 사용할지를 정합니다. 각 사용자들은 이 설정을 \'내 정보\'에서 고칠 수 있습니다.',
	'def_text_processing' => '기본 텍스트 처리',
	'text_processing' => '텍스트 처리',
	'text_processing_desc' => '기본 텍스트 처리를 정합니다. 사용자가 WYSIWYG이 아닌 편집기를 사용하고 있다면 \'줄 바꿈을 &lt;br /&gt;로 바꾸기\'는 줄 바꿈을 &lt;br&gt; 태그로 바꿉니다. <a href="http://www.textism.com/tools/textile/" target="_blank">텍스타일</a>은 강력하지만 배우기 쉬운 마크업 스타일입니다.',
	'none' => '없음',
	'convert_br' => '줄 바꿈을 &lt;br /&gt;로 바꾸기',
	'textile' => '텍스타일',

	'setup_ping' => '핑 설정',
	'ping_use' => '핑 갱신 추적자',
	'ping_use_desc' => '여러분이 새 글을 쓰면 피벗이 weblogs.com과 같은 갱신 추적자에게 알려줄지를 정합니다. blogrolling.com과 같은 서비스는 이 핑에 의존합니다.',
	'ping_urls' => '핑할 URL',
	'ping_urls_desc' => '여러분은 핑을 보낼 몇몇 URL을 설정할 수 있습니다. http:// 부분은 포함하지 마십시오. 포함한다면 정상적으로 동작하지 않을 것입니다. 각 줄마다 서버를 하나씩 입력하시거나, 파이프 문자(|)로 구분하십시오. 널리 쓰이는 핑 서버는 아래와 같습니다.<br /><b>rpc.weblogs.com/RPC2</b> (가장 널리 쓰이는 weblogs.com 핑)<br /><b>pivotlog.net/pinger</b> (아직 잘 동작하지 않는 pivotlog 핑)<br /><b>rcs.datashed.net/RPC2</b> (euro.weblogs.com 핑)<br /><b>ping.blo.gs</b> (blo.gs 핑)<br />',

	'new_window' => '링크를 새 창에서 열기',
	'emoticons' => '이모티콘 사용',
	'javascript_email' => '이메일 주소를 부호화할까요?',
	'new_window_desc' => '여러분의 글 안에 있는 링크들이 새 창에서 열릴지를 정합니다.',

	'mod_rewrite' => '파일스매치 사용',
	'mod_rewrite_desc' => '여러분이 아파치의 파일스매치(Filesmatch) 선택 사항을 사용한다면, 피벗은 URL을 www.mysite.com/pivot/entry.php?id=134 대신 www.mysite.com/archive/2003/05/30/nice_weather와 같이 만듭니다. 모든 서버가 지원하지는 않기 때문에, 사용 설명서에서 이것에 관한 부분을 읽어 보시기 바랍니다.',

	'search_index' => '검색 색인 자동 갱신',
	'search_index_desc' => '검색 색인이 여러분이 새 글을 쓸 때마다 갱신될지, 있는 글을 수정할 때마다 갱신될지 정합니다.',

	'default_introduction' => '기본 소개/본문',
	'default_introduction_desc' => '새 글을 쓸 때 소개와 본문에 들어갈 내용의 기본값을 정합니다. 보통 가장 자연스러운 빈 문단으로 합니다.',

	'upload_autothumb'	=> '자동 작은 그림',
	'upload_thumb_width' => '작은 그림 넓이',
	'upload_thumb_height' => '작은 그림 높이',
	'upload_thumb_remote' => '원격 자르기(cropping) 스크립트',
	'upload_thumb_remote_desc' => '여러분의 서버에 그림을 자를 때 필요한 라이브러리가 없을 경우, 원격으로 자르기 스크립트를 쓸 수 있습니다.',


);


//		Weblog Config	\\
$lang['weblog_config'] = array (
	'edit_weblog' => '이 웹로그를 고칩니다: ',
	'edit_blog' => '웹로그 고치기',
	'new_weblog' => '새 웹로그',
	'new_weblog_desc' => '새 웹로그를 추가합니다',
	'del_weblog' => '웹로그 지우기',
	'del_this_weblog' => '이 웹로그를 지웁니다',
	'create_new' => '새 웹로그 만들기',
	'subw_heading' => '서식에서 찾은 자식 웹로그들이 각각 무슨 서식을 쓰고 어느 갈래에 게시될 것인지 설정할 수 있습니다.',
	'create' => '완료',

	'create_1' => '웹로그 만들기 / 고치기, 3 단계 중 1단계',
	'create_2' => '웹로그 만들기 / 고치기, 3 단계 중 2단계',
	'create_3' => '웹로그 만들기 / 고치기, 3 단계 중 3단계',

	'name' => '웹로그 이름',
	'payoff' => '설명',
	'payoff_desc' => '웹로그의 부제나 간단한 설명을 쓰십시오',
	'url' => '웹로그의 URL',
	'url_desc' => '이 칸이 비어 있으면 피벗이 여러분의 웹로그의 주소를 결정합니다. 여러분의 웹로그가 프레임으로 포함되거나 다른 곳에서 불러오는 것이라면 이 설정으로 피벗의 추측을 무시할 수 있습니다.',
	'index_name' => '대문 (첫 화면)',
	'index_name_desc' => '첫 화면의 파일 이름입니다. 보통 \'index.html\'이나 \'index.php\'와 같은 모습입니다.',

	'ssi_prefix' => 'SSI 접두어',
	'ssi_prefix_desc' => '만약 여러분의 웹로그가 (추천되지 않는) SSI를 사용한다면, 여러분은 이 설정으로 피벗의 파일 이름 앞에 \'index.shtml?p=\'와 같은 SSI 용 접두어를 붙일 수 있습니다. 여러분이 무엇을 하는 것인지 정확히 알지 못한다면 빈 칸으로 남겨 두셔야 합니다.',

	'front_path' => '대문 경로',
	'front_path_desc' => '피벗이 이 블로그의 대문을 만들 곳의 절대 주소나 상대 주소입니다.',
	'file_format' => '파일 이름',
	'entry_heading' => '글 설정',
	'entry_path' => '글 경로',
	'entry_path_desc' => '(여러분이 \'글 바로 만들기\'를 쓰지 않을 때) 피벗이 글 하나짜리 페이지를 만들 곳의 절대 주소나 상대 주소입니다.',
	'live_comments' => '글 바로 만들기',
	'live_comments_desc' => '글을 미리 만들지 않고, 필요할 때 만듭니다. 여러분이 \'글 바로 만들기\'를 쓰면, 피벗은 글마다 파일을 만들 필요가 없습니다. 바람직한 설정입니다.',
	'readmore' => '\'더 읽기\' 글',
	'readmore_desc' => '대문에 보이는 것 보다 많은 글이 있다는 것을 알려주는 글입니다. 만약 비워 둔다면, 피벗은 언어 설정에 따른 기본값을 사용할 것입니다',

	'arc_heading' => '보관소 설정',
	'arc_index' => '색인 파일',
	'arc_path' => '보관소 경로',
	'archive_amount' => '보관량',
	'archive_unit' => '보관 주기',
	'archive_format' => '보관 형태',
	'archive_none' => '보관 안함',
	'archive_weekly' => '주마다 보관',
	'archive_monthly' => '달마다 보관',

	'archive_link' => '보관소 링크',
	'archive_linkfile' => '보관소 목록 형식',
	'archive_order' => '보관 순서',
	'archive_ascending' => '오름차순 (옛 글 먼저)',
	'archive_descending' => '내림차순 (새 글 먼저)',


	'templates_heading' => '서식',
	'frontpage_template' => '대문 서식',
	'frontpage_template_desc' => '대문을 볼 때의 서식입니다.',
	'archivepage_template' => '보관소 서식',
	'archivepage_template_desc' => '보관소를 볼 때의 서식입니다. \'대문 서식\'과 같을 수 있습니다.',
	'entrypage_template' => '글 서식',
	'entrypage_template_desc' => '글 하나를 볼 때의 서식입니다.',
	'extrapage_template' => '특수 서식',
	'extrapage_template_desc' => '보관소와 search.php가 어떻게 보일지를 정하는 서식입니다.',

	'shortentry_template' => '짧은글 서식',
	'shortentry_template_desc' => '웹로그나 보관소에서 글 하나가 어떻게 보일지 결정합니다.',
	'num_entries' => '글 수',
	'num_entries_desc' => '이 자식 웹로그에서 대문에 나타낼 글의 수를 정하십시오.',
	'offset' => '오프셋',
	'offset_desc' => '오프셋이 숫자로 설정되면, 페이지를 만들 때 그만큼의 글이 건너뛰어집니다. 여러분은 이를 써서 예를 들어 \'이전 글들\'목록과 같은 것을 만들 수 있습니다.',
	'comments' => '덧글을 허락하시겠습니까?',
	'comments_desc' => '사용자들이 이 자식 웹로그의 글에 덧글을 남길 수 있는지 여부를 결정하십시오.',

	'setup_rss_head' => 'RSS와 Atom 설정',
	'rss_use' => 'Feed 만들기',
	'rss_use_desc' => '피벗이 이 웹로그의 RSS와 Atom을 자동으로 만들지 여부를 정합니다.',
	'rss_filename' => 'RSS 파일 이름',
	'atom_filename' => 'Atom 파일 이름',
	'rss_path' => 'Feed 경로',
	'rss_path_desc' => '피벗이 Feed 파일을 만들 곳의 상대 경로 또는 절대 경로입니다.',
	'rss_size' => 'Feed 항목 길이',
	'rss_size_desc' => 'Feed 파일의 각 항목의 길이입니다. (바이트 단위)',

	'lastcomm_head' => '최근 덧글 설정',
	'lastcomm_amount' => '보여줄 개수',
	'lastcomm_length' => '자를 길이',
	'lastcomm_format' => '형식',
	'lastcomm_format_desc' => '이 설정은 웹로그의 대문에 있는 \'최근 덧글\'의 모양새를 결정합니다.',
	'lastcomm_redirect' => '방문 경로를 다른 곳으로',
	'lastcomm_redirect_desc' => '방문 경로 스팸을 막기 위해 링크를 다른 곳으로 보내어 스팸을 쓴 사람이 구글에서 좋은 페이지 순위를 얻는 것을 막습니다.', # 페이지 순위 = PageRank™

	'lastref_head' => '최근 방문 경로 설정',
	'lastref_amount' => '보여줄 개수',
	'lastref_length' => '자를 길이',
	'lastref_format' => '형식',
	'lastref_format_desc' => '이 설정은 웹로그의 대문에 있는 \'최근 방문 경로\'가 어떻게 보일지를 정합니다.',
	'lastref_graphic' => '그림 사용',
	'lastref_graphic_desc' => '최근 방문자가 어떤 검색 엔진을 통해서 왔는지 보여주는 작은 아이콘을 쓸지를 정합니다.',
	'lastref_redirect' => '방문 경로를 다른 곳으로',
	'lastref_redirect_desc' => '방문 경로 스팸을 막기 위해 링크를 다른 곳으로 보내어 스팸을 쓴 사람이 구글에서 좋은 페이지 순위를 얻는 것을 막습니다.', # 페이지 순위 = PageRank™

	'various_head' => '기타 설정',
	'emoticons' => '이모티콘 사용',
	'emoticons_desc' => ':-) 과 같은 이모티콘들이 그림으로 바꾸어져 보내질지 결정하십시오.',
	'encode_email_addresses' => '이메일 주소 부호화',
	'encode_email_addresses_desc' => '이메일 주소 수집기가 광고용으로 이메일 주소를 가져가는 것을 방해하기 위해 자바스크립트로 이메일 주소를 부호화하여 나타낼지 여부를 결정하십시오.',
	'target_blank' => '대상을 Blank로',
	'xhtml_workaround' => 'XHTML 돌아가기',
	'target_blank_desc' => '\'예\'를 선택하면 여러분의 글에 있는 모든 링크들은 새 창에서 열리게 됩니다. \'XHTML 돌아가기\'를 선택하면 모든 링크들은 rel="external" 속성을 가지게 되어 적격인(wellformed) XHTML을 깨지 않게 됩니다.',

	'date_head' => '날짜 표시 설정',
	'full_date' => '자세한 날짜 형식',
	'full_date_desc' => '자세한 날짜와 시각을 나타내는 형식을 결정합니다. 글이 하나있는 쪽의 맨 위에서 가장 자주 쓰입니다.',
	'entry_date' => '글 날짜',
	'diff_date' => '다른 날짜',
	'diff_date_desc' => '\'다른 날짜\'는 많은 경우 \'글 날짜\'와 함께 쓰입니다. 글 날짜가 여러분의 웹로그의 모든 글들에 표시되는 데 반해, 다른 날짜는 날짜가 이전 날짜와 다를 때에만 표시됩니다.',
	'language' => '언어',
	'language_desc' => '날짜와 숫자를 나타내는 언어와 (iso-8859-1이나 koi8-r과 같은) 인코딩할 글자 세트를 결정합니다.',

	'comment_head' => '덧글 설정',
	'comment_sendmail' => '메일을 보내시겠습니까?',
	'comment_sendmail_desc' => '덧글이 달리면 이 웹로그의 관리자에게 메일을 보냅니다.',
	'comment_emailto' => '보낼 곳',
	'comment_emailto_desc' => '메일이 보내질 이메일 주소를 기입하십시오. 여러 주소는 쉼표로 구분하십시오.',
	'comment_texttolinks' => '글을 링크로',
	'comment_texttolinks_desc' => '입력한 URL과 이메일 주소를 링크로 바꾸어 클릭할 수 있도록 만들지 정하십시오.',
	'comment_wrap' => '덧글 자르기',
	'comment_wrap_desc' => '긴 글이 여러분의 레이아웃을 망치는 것을 막기 위해서, 지정한 길이보다 긴 글은 잘리게 될 것입니다.',
	'comments_text_0' => '\'덧글이 없습니다\' 글',
	'comments_text_1' => '\'덧글이 한개 있습니다\' 글',
	'comments_text_2' => '\'덧글이 %num%개 있습니다\' 글',
	'comments_text_2_desc' => '몇개의 덧글이 있는지 알려주는 데 쓰이는 글입니다. 빈 칸으로 남겨두면 피벗은 언어 설정에 정의된 기본값을 사용할 것입니다.',

	'comment_pop' => '덧글을 팝업에서 다시겠습니까?',
	'comment_pop_desc' => '덧글(\'글 하나\') 쪽이 팝업에서 열릴지, 원래 브라우저 창에서 열릴지 정합니다.',
	'comment_width' => '팝업 넓이',
	'comment_height' => '팝업 높이',
	'comment_height_desc' => '덧글 팝업의 넓이와 높이를 (픽셀 단위로) 지정하십시오.',

	'comment_format' => "덧글 형식",
	'comment_format_desc' => "글 페이지에 덧글이 어떻게 표시될지 지정합니다.",

	'comment_textile' => '텍스타일 허가',
	'comment_textile_desc' => '이것이 \'예\'로 설정되면, 방문객들은 덧글에 <a href="http://www.textism.com/tools/textile/" target="_blank">텍스타일</a>을 쓸 수 있습니다.',

	'saved_create' => '새 웹로그가 만들어졌습니다.',
	'saved_update' => '웹로그가 갱신되었습니다.',
	'deleted' => '웹로그를 지웠습니다.',
	'confirm_delete' => '%1을 지우려고 합니다. 정말로 지우시겠습니까?',

	'blogroll_heading' => '블로그롤 설정',
	'blogroll_id' => '블로그롤 ID 번호',
	'blogroll_id_desc' => '선택적으로 <a href="http://www.blogrolling.com" target="_blank">blogrolling.com</a> 블로그롤을 여러분의 웹로그에 넣을 수 있습니다. 블로그롤은 링크들이 얼마나 최근에 갱신되었는지를 보여주는, 링크들의 목록을 관리할 때 아주 유용한 서비스입니다. 여러분이 이를 쓰고 싶지 않으시면, 이 입력 항목을 건너뛰십시오. 쓰고 싶으시면, blogrolling.com에 로그인 한 뒤 \'get code\'에서 여러분의 블로그롤 ID 번호를 포함하는 링크를 보실 수 있습니다. 2ef8b42161020d87223d42ae18191f6d 와 같이 생겼습니다.',
	'blogroll_fg' => '글씨 색',
	'blogroll_bg' => '배경 색',
	'blogroll_line1' => '선 색 1',
	'blogroll_line2' => '선 색 2',
	'blogroll_c1' => '색 1',
	'blogroll_c2' => '색 2',
	'blogroll_c3' => '색 3',
	'blogroll_c4' => '색 4',
	'blogroll_c4_desc' => '이 색들은 여러분의 블로그롤이 어떻게 보일지를 정합니다. 색 1부터 색 4까지로 얼마나 최근에 링크가 갱신되었는지를 시각적으로 알려줍니다.',
);


$lang['upload'] = array (
	//		File Upload		\\
	'preview' => '모든 목록 비리보기',
	'thumbs' => '작은그림 미리보기',
	'create_thumb' => '(작은그림 만들기)',
	'title' => '파일',
	'thisfile' => '새 파일 올리기:',
	'button' => '올리기',
	'filename' => '파일 이름',
	'thumbnail' => '작은그림',
	'date' => '날짜',
	'filesize' => '파일 크기',
	'dimensions' => '넓이 x 높이',
	'delete_title' => '그림 지우기',
	'areyousure' => '%s 지우시겠습니까?',
	'picheader' => '이 그림을 지우시겠습니까?',
	'create' => '만들기',
	'edit' => '고치기',

	'insert_image' => '그림을 집어넣기',
	'insert_image_desc' => '그림을 집어넣기 위해서는 그림을 올리거나 올려진 그림을 선택해야 합니다.',
	'insert_image_popup' => '팝업 그림을 집어넣기',
	'insert_image_popup_desc' => '그림을 집어넣기 위해서는 그림을 올리거나 올려진 그림을 선택해야 합니다. 그 다음에 팝업을 여는 작은그림이나 글을 고르십시오.',
	'choose_upload' => '올리기',
	'choose_select' => '선택',
	'imagename' => '그림 이름',
	'alt_text' => '대신 표시할 글',
	'align' => '정렬',
	'border' => '테두리',
	'pixels' => '픽셀',
	'uploaded_as' => '파일이 \'%s\'로 올려졌습니다.',
	'not_uploaded' => '파일이 올려지지 못했습니다. 다음과 같은 에러가 일어났습니다:',
	'center' => '가운데 (기본값)',
	'left' => '왼쪽',
	'right' => '오른쪽',
	'inline' => '줄 안에',
	'notice_upload_first' => '먼저 그림을 고르거나 올려야 합니다',
	'select_image' => '그림 선택',

	'for_popup' => '팝업을 열 때',
	'use_thumbnail' => '작은그림 사용',
	'edit_thumbnail' => '작은그림 고치기',
	'use_text' => '글 사용',
);


$lang['link'] = array (
	//		Link Insertion \\
	'insert_link' => '링크 집어넣기',
	'insert_link_desc' => '아래의 칸에 URL을 입력하여 링크를 집어넣으십시오. 방문자는 마우스를 링크 위에 올려놓으면 제목을 볼 것입니다.',
	'url' => 'URL',
	'title' => '제목',
	'text' => '내용',
);


//		Categories		\\
$lang['category'] = array (
	'edit_who' => '\'%s\' 갈래에 누가 글을 쓸 수 있는지 고치십시오',
	'name' => '이름',
	'users' => '사용자',
	'make_new' => '새 갈래 만들기',
	'create' => '갈래 만들기',
	'canpost' => '이 갈래에 글을 쓸 수 있게 하고 싶은 사용자를 고르십시오',
	'same_name' => '이 이름을 가지는 갈래가 이미 있습니다',
	'need_name' => '이 갈래는 이름이 필요합니다',

	'allowed' => '허가됨',
	'allow' => '허가',
	'denied' => '금지됨',
	'deny' => '금지',
	'edit' => '갈래 고치기',

	'delete' => '갈래 지우기',
	'delete_desc' => '이 갈래를 지우고 싶으시면 \'예\'를 선택하십시오',

	'delete_message' => '피벗의 현재 판에서는 갈래 이름만이 지워집니다. 다음 판에서는 갈래 안의 글들을 어떻게 할지를 선택할 수 있을 것입니다.',
);


$lang['entries'] = array (
	//		Entries			\\
	'post_entry' => "글 쓰기",
	'preview_entry' => "글 미리 보기",

	'first' => '처음',
	'last' => '마지막',
	'next' => '다음',
	'previous' => '이전',

	'jumptopage' => '(%num%)번째 쪽으로 가기',
	'filteron' => '(%name%)로 거르기',
	'filteroff' => '거르지 않기',
	'title' => '제목',
	'subtitle' => '부제',
	'introduction' => '소개',
	'body' => '본문',
	'publish_on' => '게시된 시각',
	'status' => '상태',
	'post_status' => '게시 상태',
	'category' => '갈래',
	'select_multi_cats' => '(여러 갈래를 고르시려면 Ctrl키를 누른 상태에서 클릭하십시오)',
	'last_edited' => "가장 최근에 고친 시각",
	'created_on' => "만들어진 시각",
	'date' => '날짜',
	'author' => '글쓴이',
	'code' => '코드',
	'comm' => '덧글 수',
	'name' => '이름',
	'allow_comments' => '덧글 허가',
	'convert_lb' => '줄바꿈 변환',
	'always_off' => '(WYSIWYG 모드에서는 언제나 꺼져 있습니다)',
	'be_careful' => '(조심하세요!)',
	'edit_comments' => '덧글 고치기',
	'edit_comments_desc' => '이 글의 덧글을 고칩니다',
	'edit_comment' => '고치기',
	'delete_comment' => '지우기',
	'block_single' => 'IP %s 차단',
	'block_range' => 'IP 범위 %s 차단',
	'unblock_single' => 'IP %s 차단 해제',
	'unblock_range' => 'IP 범위 %s 차단 해제',
	'trackback' => '트랙백 주소',
);


//		Form Fun		\\
$lang['forms'] = array (
	'c_all' => '전체 선택',
	'c_none' => '전체 해제',
	'choose' => '- select an option -',
	'publish' => '\'게시\' 상태로 전환',
	'hold' => '\'보관\' 상태로 전환',
	'delete' => '지우기',
	'generate' => '게시하고 만들기',

	'with_checked_entries' => "선택한 글을:",
	'with_checked_files' => "선택한 파일을:",
	'with_checked_templates' => '선택한 서식을:',
);


//		Errors			\\
$lang['error'] = array (
	'path_open' => '디렉토리를 열 수 없습니다. 권한을 확인하세요.',
	'path_read' => '디렉토리를 읽을 수 없습니다. 권한을 확인하세요.',
	'path_write' => '디렉토리에 쓸 수 없습니다. 권한을 확인하세요.',

	'file_open' => '파일을 열 수 없습니다. 권한을 확인하세요.',
	'file_read' => '파일을 읽을 수 없습니다. 권한을 확인하세요.',
	'file_write' => '파일에 쓸 수 없습니다. 권한을 확인하세요.',
);


//		Notices			\\
$lang['notice'] = array (
	'comment_saved' => "덧글이 저장되었습니다.",
	'comment_deleted' => "덧글이 삭제되었습니다.",
	'comment_none' => "이 글에는 덧글이 없습니다.",
);


// Comments, Karma and voting \\
$lang['karma'] = array (
	'vote' => '이 항목은 \'%val%\'고 투표하세요',
	'good' => '좋다',
	'bad' => '나쁘다',
	'already' => '이미 이 글이나 설문에 투표하셨습니다',
	'register' => '여러분이 \'%val%\'고 투표한 결과가 등록되었습니다',
);


$lang['comment'] = array (
	'register' => '덧글이 저장되었습니다.',
	'preview' => '덧글을 미리보고 있습니다. \'덧글 쓰기\'를 눌러야 저장됩니다.',
	'duplicate' => '이미 같은 내용의 덧글이 있기 때문에, 저장되지 않았습니다.',
	'no_name' => '이름이나 별명을 \'이름\' 항목에 써 넣으셔야 합니다. 써 넣으신 뒤 \'덧글 쓰기\'를 눌러야 저장됩니다.',
	'no_comment' => '내용이 없습니다. 무언가를 \'덧글\' 항목에 써 넣으셔야 합니다. 써 넣으신 뒤 \'덧글 쓰기\'를 눌러야 저장됩니다.',
);


$lang['comments_text'] = array (
	'0' => "덧글 없음",
	'1' => "덧글 %num%개",
	'2' => "덧글 %num%개",
);


$lang['weblog_text'] = array (
	// these are used in the weblogs, for the labels related to archives
	'archives' => "보관소",
	'next_archive' => "다음 보관소",
	'previous_archive' => "이전 보관소",
	'last_comments' => "최근 덧글",
	'last_referrers' => "최근 방문 경로",
	'calendar' => "달력",
	'links' => "다른 곳들",
	'xml_feed' => "XML: RSS Feed", # XML 먹이기
	'powered_by' => "Powered by", # 다음 프로그램으로 운영됩니다:
	'name' => "이름",
	'email' => "이메일",
	'url' => "홈페이지",
	'date' => "날짜",
	'comment' => "덧글",
	'ip' => "IP 주소",
	'yes' => "예",
	'no' => "아니오",
	'emoticons' => "이모티콘",
	'emoticons_reference' => "이모티콘 참고서를 엽니다",
	'textile' => "텍스타일",
	'textile_reference' => "텍스타일 참고서를 엽니다",
	'post_comment' => "덧글 쓰기",
	'preview_comment' => "덧글 미리보기",
	'remember_info' => "개인 정보를 기억할까요?",
	'disclaimer' => "<b>참고:</b> 덧글에 &lt;b&gt;와 &lt;i&gt; 밖의 테그를 쓰시면 지워지게 됩니다. URL이나 메일 주소만 입력해도 링크가 만들어집니다.",
	'search_title' => "검색 결과",
	'search' => "검색",
	'nomatches' => "'%name%'에 맞는 검색 결과가 없습니다. 다른 검색어로 시도하세요.",
	'matches' => "'%name%'의 검색 결과:",
);


$lang['ufield_main'] = array (
	//		Userfields		\\
	'title' => '사용자 항목 고치기',
	'edit' => '고치기',
	'create' => '만들기',

	'dispname' => '표시 이름',
	'intname' => '내부 이름',
	'intname_desc' => '내부 이름은 서식에서 피벗에게 이 항목을 출력하라고 할 때 쓰이는 이름입니다.',
	'size' => '크기',
	'rows' => '행',
	'cols' => '열',
	'maxlen' => '최장 길이',
	'minlevel' => '최소 사용자 수준',
	'filter' => '거르기',
	'filter_desc' => '이 항목을 거르면, 쓸 수 있는 입력의 유형이 제한됩니다',
	'no_filter' => '없음',
	'del_title' => '지우기 확인',
	'del_desc' => '사용자 항목(<b>%s</b>)을 지우면 사용자들이 저장했던 자료도 사라지고, 서식에 적용되었던 내용은 빈 것으로 보입니다.',

	'already' => '이 이름은 이미 쓰이고 있습니다.',
	'int' => '내부 이름은 3자 보다 길어야 합니다.',
	'short_disp' => '표시 이름은 3자보다 길어아 합니다.',
);


$lang['bookmarklets'] = array (
	'bookmarklets' => '빠른 도구',
	'bm_add' => '빠른 도구를 더합니다.',
	'bm_withlink' => '피벗 » 새 글',
	'bm_withlink_desc' => '이 빠른 도구는 여는 페이지로의 링크를 포함하는 새 글을 엽니다.',

	'bm_nolink' => '피벗 » 새 글',
	'bm_nolink_desc' => '이 빠른 도구는 비어 있는 새 글이 있는 창을 엽니다.',

	'bookmarklets_info' => '여러분은 빠른 도구를 써서 피벗에 새 글을 간단히 쓸 수 있습니다. 빠른 도구를 여러분의 브라우저에 추가하려면, 아래 방법 중에서 하나를 사용하십시오. 여러분이 사용하는 브라우저에 따라 자세한 내용은 다를 수도 있습니다.',
	'bookmarklets_info_1' => '빠른 도구를 \'책갈피(즐겨찾기)\' 툴바나 버튼으로 끄십시오.',
	'bookmarklets_info_2' => '빠른 도구를 마우스 오른쪽으로 클릭해서 \'책갈피(즐겨찾기)에 추가\'를  고르십시오.',
);


// A little tool to help you check if the file is correct..
if (count(get_included_files())<2) {

	$groups = count($lang);
	$total = 0;
	foreach ($lang as $langgroup) {
		$total += count($langgroup);
	}
	echo "<h2>Language file is correct!</h2>";
	echo "This file contains $groups groups and a total of $total labels.";

}

?>
