<?php

$old_errrep = error_reporting(0);
//$old_errrep = error_reporting(E_ALL);

// Lamer protection
$currentfile = basename(__FILE__);
require dirname(dirname(__FILE__))."/lamer_protection.php";

// -----------------------
// wrapped by a 'function_exists', since it might already be defined..
if (!function_exists('safe_string')) {
	function safe_string($str, $strict=FALSE) {

		$str = strip_tags($str);

		$str = strtr (
				strtr($str,
					'',
					'SZszYAAAAACEEEEIIIINOOOOOUUUYaaaaaaceeeeiiiinooooouuuyy'),
				array(
					'' => 'TH', 
					'' => 'th', 
					'' => 'DH', 
					'' => 'dh', 
					'' => 'ae', 
					'' => 'ue', 
					'' => 'oe', 
					'' => 'AE', 
					'' => 'UE', 
					'' => 'OE', 
					'' => 'ss', 
					'' => 'OE', 
					'' => 'oe', 
					'' => 'AE', 
					'' => 'ae', 
					'' => 'mu'
				)
			);

		$str=str_replace("&amp;", "", $str);

		if ($strict) {
			$str=str_replace(" ", "_", $str);
			$str=strtolower(ereg_replace("[^a-zA-Z0-9_]", "", $str));
		} else {
			$str=ereg_replace("[^a-zA-Z0-9 _.,-]", "", $str);
		}
		return $str;
	}
}



// -----------------------
// Main
// -----------------------

$rssformat = stripslashes($rssformat);

define('MAGPIE_DIR', dirname(__FILE__).'/magpierss/');
define('MAGPIE_CACHE_DIR', $pivot_path.'./db/rsscache/');
define('MAGPIE_FETCH_TIME_OUT', 5);	// 5 second timeout
if (isset($rss_cache_age) && is_int($rss_cache_age)) {
	define('MAGPIE_CACHE_AGE', $rss_cache_age);
} else {
	define('MAGPIE_CACHE_AGE', 60*60*8); // 8 hours
}
define('MAGPIE_OUTPUT_ENCODING', snippet_charset());

if ( (!isset($trimlen)) || !is_numeric($trimlen) || ( $trimlen<=0 && $trimlen!=-1)) {
	$trimlen = 60;	
}
if ( (!isset($rssmax)) || !is_numeric($rssmax) || ($rssmax<=0)) {
	$rssmax = 10;	
}
if ( (!isset($rssstart)) || !is_numeric($rssstart) || ($rssstart<=0)) {
	$rssstart = 1;	
}

require_once('magpierss/rss_fetch.inc');

$feed = fetch_rss($rssurl);

$count = 0;
$rssmax += $rssstart;

foreach ( $feed->items as $item ) {

    $count++;
    if ($count < $rssstart) {
        continue;
    } elseif ($count>=$rssmax) {
        break;
    }
    $itemformat = $rssformat;
    // Supporting upto two level arrays in item elements.
    foreach ($item as $key => $value) {
        if (is_string($value)) {
            if ($key == "link" || $trimlen==-1) {
                $value = trim($value);
            } else {
                $value = trimtext(trim($value), $trimlen);
            }
            $itemformat = str_replace("%$key%", $value, $itemformat);
        } else if (is_array($value)) {
            foreach ($value as $arrkey => $arrvalue) {
                if (is_string($arrvalue)) {
                    $arrvalue = trim($arrvalue);
                    if ($trimlen!=-1) {
                        $arrvalue = trimtext($arrvalue, $trimlen);
                    }
                    $itemformat = str_replace("%$key".'->'."$arrkey%", $arrvalue, $itemformat);
                } else if (is_array($arrvalue)) {
                    foreach ($arrvalue as $subarrkey => $subarrvalue) {
                        if (is_string($subarrvalue)) {
                            $subarrvalue = trim($subarrvalue);
                            if ($trimlen!=-1) {
                                $subarrvalue = trimtext($subarrvalue, $trimlen);
                            }
                            $itemformat = str_replace("%$key".'->'."$arrkey".'->'."$subarrkey%", $subarrvalue, $itemformat);
                        }
                    }
                }
            }
        }
    }

    // Remove any unused formatting tags.
    $itemformat = preg_replace("/%[^%]+%/", "", $itemformat);

    echo $itemformat;
}

error_reporting($old_errrep);

?>
