/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.favorites;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.common.log.NLogger;
import phex.xml.sax.favorites.DFavoriteHost;
import phex.xml.sax.parser.ParserUtils;

public class FavoriteHostHandler
extends DefaultHandler {
    public static final String THIS_TAG_NAME = "favorite-host";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DFavoriteHost dHost;
    private DefaultHandler parent;

    public FavoriteHostHandler(DFavoriteHost dHost, Attributes attributes, DefaultHandler parent, SAXParser parser) {
        this.dHost = dHost;
        this.parser = parser;
        this.parent = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("host-name")) {
            this.dHost.setHostName(this.text.toString());
        } else if (qName.equals("ip")) {
            this.dHost.setIp(ParserUtils.fromHexBinary(this.text.toString()));
        } else if (qName.equals("port")) {
            try {
                this.dHost.setPort(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(FavoriteHostHandler.class, exp, exp);
            }
        } else if (qName.equals(THIS_TAG_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

