/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RSSParser {
    private static final String EOL_CHARACTERS = "\r\n";
    private static final char[] AMPERSAND_AMP = new char[]{'a', 'm', 'p', ';'};
    private static final String START_OF_ELEMENT_CHAR = "<";
    private static final String END_OF_ELEMENT_CHAR = ">";
    private static final String END_OF_ELEMENT_CHARN = "/";
    private static final char[] XML_LINE = new char[]{'<', '?', 'x', 'm', 'l'};
    private static final char[] MAGNET_PREFIX = new char[]{'m', 'a', 'g', 'n', 'e', 't'};
    private static final char[] HTTP_PREFIX = new char[]{'h', 't', 't', 'p', ':', '/'};
    private static final char[] MAGNET_TAG = new char[]{'<', 'm', 'a', 'g', 'n', 'e', 't', '>'};
    private static final char[] ENCLOSURE_TAG_START = new char[]{'<', 'e', 'n', 'c', 'l', 'o', 's', 'u'};
    private static final char[] ENCLOSURE_TAG_MID = new char[]{'r', 'e'};
    private static final char[] URL_IDENTIFIER = new char[]{'u', 'r', 'l', '=', '\"'};
    private static final char[] ITEM_ELEMENT = new char[]{'<', 'i', 't', 'e', 'm', '>'};
    private static final char[] END_OF_ITEM_ELEMENT = new char[]{'<', '/', 'i', 't', 'e', 'm', '>'};
    private static final char[] RSS_TAG = new char[]{'<', 'r', 's', 's', '>'};
    private static final char[] END_OF_RSS_TAG = new char[]{'<', '/', 'r', 's', 's', '>'};
    private PushbackReader reader;
    private List<String> magnets = new ArrayList<String>();

    public RSSParser(Reader reader) {
        this.reader = new PushbackReader(reader, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        try {
            int count;
            char[] buff = new char[5];
            for (int readBytes = 0; readBytes != 5; readBytes += count) {
                count = this.reader.read(buff, readBytes, 5);
                if (count != -1) continue;
                throw new IOException("Input file is no XML-File (" + String.valueOf(buff) + ").");
            }
            if (Arrays.equals(buff, XML_LINE)) {
                this.parseXml();
            }
        }
        finally {
            this.reader.close();
        }
    }

    public List getMagnets() {
        return this.magnets;
    }

    private void parseXml() throws IOException {
        int pos = 0;
        while (true) {
            int c;
            if ((c = this.reader.read()) == RSS_TAG[pos]) {
                if (++pos != RSS_TAG.length) continue;
                this.parseList();
                pos = 0;
                continue;
            }
            if (c == -1) {
                return;
            }
            pos = 0;
            this.parseList();
        }
    }

    private void parseList() throws IOException {
        int pos = 0;
        while (true) {
            int c;
            if ((c = this.reader.read()) == ITEM_ELEMENT[pos]) {
                if (++pos != ITEM_ELEMENT.length) continue;
                this.parseItemBody();
                pos = 0;
                continue;
            }
            if (c == END_OF_RSS_TAG[pos]) {
                if (++pos != END_OF_RSS_TAG.length) continue;
                pos = 0;
                return;
            }
            if (c == -1) {
                return;
            }
            pos = 0;
        }
    }

    public void parseItemBody() throws IOException {
        int pos = 0;
        block0: while (true) {
            int readBytes;
            int count;
            char[] buff;
            int c;
            if ((c = this.reader.read()) == MAGNET_TAG[pos]) {
                if (++pos != MAGNET_TAG.length) continue;
                buff = new char[6];
                for (readBytes = 0; readBytes != 6; readBytes += count) {
                    count = this.reader.read(buff, readBytes, 6);
                    if (count != -1) continue;
                    return;
                }
                this.reader.unread(buff);
                if (Arrays.equals(buff, MAGNET_PREFIX)) {
                    pos = 0;
                    this.parseMagnet();
                } else if (Arrays.equals(buff, HTTP_PREFIX)) {
                    pos = 0;
                    this.parseMagnet();
                }
                pos = 0;
                continue;
            }
            if (c == ENCLOSURE_TAG_START[pos]) {
                if (++pos != ENCLOSURE_TAG_START.length) continue;
                pos = 0;
                while (true) {
                    if ((c = this.reader.read()) == URL_IDENTIFIER[pos]) {
                        if (++pos != URL_IDENTIFIER.length) continue;
                        buff = new char[6];
                        for (readBytes = 0; readBytes != 6; readBytes += count) {
                            count = this.reader.read(buff, readBytes, 6);
                            if (count != -1) continue;
                            return;
                        }
                        this.reader.unread(buff);
                        if (Arrays.equals(buff, MAGNET_PREFIX)) {
                            pos = 0;
                            this.parseMagnet();
                            continue block0;
                        }
                        if (!Arrays.equals(buff, HTTP_PREFIX)) continue;
                        pos = 0;
                        this.parseMagnet();
                        continue block0;
                    }
                    if (END_OF_ELEMENT_CHAR.indexOf(c) != -1) {
                        pos = 0;
                        continue block0;
                    }
                    if (c == -1) {
                        pos = 0;
                        return;
                    }
                    pos = 0;
                }
            }
            if (c == -1) {
                pos = 0;
                return;
            }
            if (pos <= 6 && c == END_OF_ITEM_ELEMENT[pos]) {
                if (++pos != END_OF_ITEM_ELEMENT.length) continue;
                pos = 0;
                return;
            }
            pos = 0;
        }
    }

    public void parseMagnet() throws IOException {
        StringBuffer magnetBuf = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.reader.read()) == 32 || EOL_CHARACTERS.indexOf(c) != -1) {
                continue;
            }
            if (c == 60 || c == 34) break;
            if (c == -1) {
                return;
            }
            if (c == 38) {
                int count;
                char[] buff = new char[4];
                for (int readBytes = 0; readBytes != 4; readBytes += count) {
                    count = this.reader.read(buff, readBytes, 4);
                    if (count != -1) continue;
                    return;
                }
                if (Arrays.equals(buff, AMPERSAND_AMP)) {
                    magnetBuf.append('&');
                    continue;
                }
                this.reader.unread(buff);
                magnetBuf.append((char)c);
                continue;
            }
            magnetBuf.append((char)c);
        }
        this.magnets.add(magnetBuf.toString());
    }

    private void skipToEndOfObject() throws IOException {
        int c;
        while ((c = this.reader.read()) >= 0) {
            if (START_OF_ELEMENT_CHAR.indexOf(c) != -1) {
                c = this.reader.read();
                if (END_OF_ELEMENT_CHARN.indexOf(c) != -1) {
                    return;
                }
                this.reader.unread(c);
                continue;
            }
            if (END_OF_ELEMENT_CHARN.indexOf(c) == -1) continue;
            c = this.reader.read();
            if (END_OF_ELEMENT_CHAR.indexOf(c) != -1) {
                return;
            }
            this.reader.unread(c);
        }
        return;
    }
}

