/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthLimitedInputStream
extends FilterInputStream {
    private long lengthLimit;
    private long lengthRead;
    private boolean closed = false;

    public LengthLimitedInputStream(InputStream in, long maxLength) {
        super(in);
        this.lengthLimit = maxLength;
    }

    public void setLengthLimit(long maxLength) {
        this.lengthLimit = maxLength;
        this.lengthRead = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                byte[] buffer = new byte[1024];
                while (this.read(buffer) >= 0) {
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.lengthRead >= this.lengthLimit) {
            return -1;
        }
        ++this.lengthRead;
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.lengthRead >= this.lengthLimit) {
            return -1;
        }
        if (this.lengthRead + (long)len > this.lengthLimit) {
            len = (int)(this.lengthLimit - this.lengthRead);
        }
        int count = super.read(b, off, len);
        this.lengthRead += (long)count;
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

