/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import phex.io.buffer.ByteBuffer;

public final class HexConverter {
    private static final char[] hexValueArray = new char[16];

    public static final String toHexString(ByteBuffer buffer, int length) {
        return HexConverter.toHexString(buffer, length, null);
    }

    public static final String toHexString(ByteBuffer buffer, int length, String separator) {
        if (length < 1) {
            throw new IllegalArgumentException("Length " + length + " < 1 ");
        }
        boolean isLimited = buffer.remaining() > length;
        int size = isLimited ? length : buffer.remaining();
        if (size == 0) {
            return "empty";
        }
        StringBuffer out = new StringBuffer(buffer.remaining() * 3 - 1);
        int mark = buffer.position();
        int byteValue = buffer.get() & 0xFF;
        out.append(byteValue >> 4 & 0xF);
        out.append(byteValue & 0xF);
        --size;
        while (size > 0) {
            if (separator != null) {
                out.append(separator);
            }
            byteValue = buffer.get();
            out.append(byteValue >> 4 & 0xF);
            out.append(byteValue & 0xF);
            --size;
        }
        buffer.position(mark);
        if (isLimited) {
            out.append("...");
        }
        return out.toString();
    }

    public static final String toHexString(byte[] data) {
        if (data.length == 0) {
            return "";
        }
        return HexConverter.toHexString(data, 0, data.length);
    }

    public static final String toHexString(byte[] data, int offset, int length) {
        return HexConverter.toHexString(data, offset, length, null);
    }

    public static final String toHexString(byte[] data, int offset, int length, String separator) {
        if (length < 1) {
            throw new IllegalArgumentException("Length " + length + " < 1 ");
        }
        int end = offset + length;
        if (offset > data.length || end > data.length) {
            throw new IndexOutOfBoundsException("Data length: " + data.length + " offset: " + offset + " length: " + length);
        }
        StringBuffer buffer = new StringBuffer(length * 2);
        buffer.append(hexValueArray[data[offset] >> 4 & 0xF]);
        buffer.append(hexValueArray[data[offset] & 0xF]);
        for (int i = offset + 1; i < end; ++i) {
            if (separator != null) {
                buffer.append(separator);
            }
            buffer.append(hexValueArray[data[i] >> 4 & 0xF]);
            buffer.append(hexValueArray[data[i] & 0xF]);
        }
        return buffer.toString();
    }

    public static final String toHexString(byte data) {
        StringBuffer buffer = new StringBuffer(2);
        buffer.append(hexValueArray[data >> 4 & 0xF]);
        buffer.append(hexValueArray[data & 0xF]);
        return buffer.toString();
    }

    public static final byte[] toBytes(String hexString) {
        if (hexString == null) {
            throw new NullPointerException("HexString is null");
        }
        int length = hexString.length();
        if (length % 2 != 0) {
            throw new NumberFormatException("Hex string has odd characters: " + hexString);
        }
        byte[] data = new byte[length / 2];
        int i = 0;
        int offset = 0;
        while (i < length) {
            byte lowNibble;
            byte highNibble;
            char highChar = hexString.charAt(i);
            if (highChar >= '0' && highChar <= '9') {
                highNibble = (byte)(highChar - 48);
            } else if (highChar >= 'A' && highChar <= 'F') {
                highNibble = (byte)(10 + highChar - 65);
            } else if (highChar >= 'a' && highChar <= 'f') {
                highNibble = (byte)(10 + highChar - 97);
            } else {
                throw new NumberFormatException("Invalid hex char: " + highChar);
            }
            char lowChar = hexString.charAt(i + 1);
            if (lowChar >= '0' && lowChar <= '9') {
                lowNibble = (byte)(lowChar - 48);
            } else if (lowChar >= 'A' && lowChar <= 'F') {
                lowNibble = (byte)(10 + lowChar - 65);
            } else if (lowChar >= 'a' && lowChar <= 'f') {
                lowNibble = (byte)(10 + lowChar - 97);
            } else {
                throw new NumberFormatException("Invalid hex char: " + lowChar);
            }
            data[offset] = (byte)(highNibble << 4 | lowNibble);
            i += 2;
            ++offset;
        }
        return data;
    }

    static {
        HexConverter.hexValueArray[0] = 48;
        HexConverter.hexValueArray[1] = 49;
        HexConverter.hexValueArray[2] = 50;
        HexConverter.hexValueArray[3] = 51;
        HexConverter.hexValueArray[4] = 52;
        HexConverter.hexValueArray[5] = 53;
        HexConverter.hexValueArray[6] = 54;
        HexConverter.hexValueArray[7] = 55;
        HexConverter.hexValueArray[8] = 56;
        HexConverter.hexValueArray[9] = 57;
        HexConverter.hexValueArray[10] = 65;
        HexConverter.hexValueArray[11] = 66;
        HexConverter.hexValueArray[12] = 67;
        HexConverter.hexValueArray[13] = 68;
        HexConverter.hexValueArray[14] = 69;
        HexConverter.hexValueArray[15] = 70;
    }
}

