/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.utils.IOUtil;

public class GnutellaInputStream
extends InputStream {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final Logger logger = LoggerFactory.getLogger(GnutellaInputStream.class);
    private int READ_BUFFER_LENGTH = 2048;
    private int LINE_BUFFER_LENGTH = 64;
    private volatile byte[] buffer;
    private int position;
    private int count;
    private volatile InputStream inStream;
    private Inflater inflater;

    public GnutellaInputStream(InputStream aInputStream) {
        this.inStream = aInputStream;
        this.buffer = new byte[this.READ_BUFFER_LENGTH];
    }

    public void activateInputInflation() throws IOException {
        this.inflater = new Inflater();
        if (this.count - this.position > 0) {
            byte[] dummy = new byte[this.count - this.position];
            System.arraycopy(this.buffer, this.position, dummy, 0, this.count - this.position);
            this.inflater.setInput(dummy);
            try {
                this.inflater.inflate(this.buffer);
            }
            catch (DataFormatException exp) {
                logger.error(exp.toString(), (Throwable)exp);
                throw new IOException(exp.getMessage());
            }
        }
        InflaterInputStream inflaterInStream = new InflaterInputStream(this.inStream, this.inflater);
        this.inStream = inflaterInStream;
        this.count = 0;
        this.position = 0;
    }

    public String readLine() throws IOException {
        if (this.inStream == null) {
            return null;
        }
        int totalIn = 0;
        if (this.inflater != null) {
            totalIn = this.inflater.getTotalIn();
        }
        StringBuffer lineBuffer = new StringBuffer(this.LINE_BUFFER_LENGTH);
        int lengthRead = 0;
        while (true) {
            int c = this.read();
            ++lengthRead;
            if (c < 0) {
                if (lineBuffer.length() != 0) break;
                return null;
            }
            if (c == 13) continue;
            if (c == 10) break;
            lineBuffer.append((char)c);
        }
        return lineBuffer.toString();
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.inStream == null) {
            return -1;
        }
        if ((offset | length | offset + length | b.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        int totalIn = 0;
        if (this.inflater != null) {
            totalIn = this.inflater.getTotalIn();
        }
        int lengthRead = this.readInternal(b, offset, length);
        return lengthRead;
    }

    private int readInternal(byte[] b, int off, int len) throws IOException {
        int cnt;
        int avail = this.count - this.position;
        if (avail <= 0) {
            if (len >= this.buffer.length) {
                if (this.inStream == null) {
                    return -1;
                }
                return this.inStream.read(b, off, len);
            }
            this.fill();
            avail = this.count - this.position;
            if (avail <= 0) {
                return -1;
            }
        }
        int n = cnt = avail < len ? avail : len;
        if (this.inStream == null) {
            return -1;
        }
        System.arraycopy(this.buffer, this.position, b, off, cnt);
        this.position += cnt;
        return cnt;
    }

    public int peek() throws IOException {
        if (this.position >= this.count) {
            this.fill();
            if (this.position >= this.count) {
                return -1;
            }
        }
        return this.buffer[this.position] & 0xFF;
    }

    public int read() throws IOException {
        if (this.position >= this.count) {
            this.fill();
            if (this.position >= this.count) {
                return -1;
            }
        }
        return this.buffer[this.position++] & 0xFF;
    }

    public synchronized int available() throws IOException {
        return this.count - this.position + this.inStream.available();
    }

    public void close() {
        IOUtil.closeQuietly(this.inStream);
        this.inStream = null;
        this.position = 0;
        this.count = 0;
        this.buffer = IOUtil.EMPTY_BYTE_ARRAY;
    }

    protected void fill() throws IOException {
        this.position = 0;
        this.count = 0;
        try {
            int nRead = this.inStream.read(this.buffer, 0, this.buffer.length);
            if (nRead > 0 && this.inStream != null) {
                this.count = nRead;
            }
        }
        catch (EOFException exp) {
            return;
        }
    }
}

